package com.bxm.localnews.convert.impl;

import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsStatus;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class NewsStatusConverter extends AbstractConverter<NewsStatus, News> {


    @Override
    public News convert(NewsStatus data) {
        News localNews = new News();
        localNews.setId(data.getId());
        localNews.setReviewStatus(data.getReviewStatus());
        localNews.setStatus(data.getStatus());
        localNews.setHot(data.getHot());
        localNews.setIsRecommend(data.getIsRecommend());

        if (StringUtils.isNotBlank(data.getAreaDetail())) {
            localNews.setAreaDetail(data.getAreaDetail());
        } else {
            localNews.setAreaDetail(null);
        }

        return localNews;
    }
}
