package com.bxm.localnews.convert.impl;

import com.bxm.localnews.sync.vo.local.LocalVideo;
import com.bxm.localnews.sync.vo.spider.SpiderVideo;
import com.bxm.newidea.component.tools.RandomUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;

@Component
public class VideoConverter extends AbstractConverter<SpiderVideo, LocalVideo> {

    @Override
    public LocalVideo convert(SpiderVideo spiderVideo) {
        LocalVideo localVideo = new LocalVideo();
        localVideo.setId(spiderVideo.getId());
        localVideo.setAuthorImg(spiderVideo.getAuthorImageUrl());
        localVideo.setAuthorName(spiderVideo.getNickname());
        localVideo.setCreateTime(spiderVideo.getCreateTime());
        localVideo.setTitle(spiderVideo.getTitle());
        localVideo.setIssueTime(spiderVideo.getCreateTime());
        localVideo.setVideoImg(spiderVideo.getVideoImageUrl());
        localVideo.setVideoUrl(spiderVideo.getVideoUrl());
        //视频状态（0：无效，1：有效）
        localVideo.setStatus((byte) 1);
        //是否已删除(0:未删除，1：已删除)
        localVideo.setIsDelete((byte) 0);
        localVideo.setClickCount(RandomUtils.nextLong(500, 50000));
        localVideo.setCommentCount(0L);
        localVideo.setShareCount(0L);
        BigDecimal rate = new BigDecimal((RandomUtils.nextInt(3, 40))).divide(new BigDecimal(100));
        BigDecimal likeCount = rate.multiply(new BigDecimal(localVideo.getClickCount()));
        localVideo.setLikeCount(likeCount.longValue());
        localVideo.setKeywordList(spiderVideo.getKeywordList());
        localVideo.setWidthRatio(spiderVideo.getWidthRatio());

        if (!CollectionUtils.isEmpty(spiderVideo.getVideoComments())) {
            localVideo.setNewsReplyList(convertNewsCommentToNewReply(spiderVideo.getVideoComments()));
        }

        return localVideo;
    }



}
