package com.bxm.localnews.convert.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.sync.enums.LocalNewStatusEnum;
import com.bxm.localnews.sync.enums.LocalNewsTypeEnum;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsImg;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.github.pagehelper.util.StringUtil;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@Component
public class WechatNewsConverter extends AbstractConverter<SpiderWechatNews, News> {
    @Override
    public News convert(SpiderWechatNews spiderWechatNews) {
        News localNews = new News();
        localNews.setId(spiderWechatNews.getId());
        localNews.setTitle(spiderWechatNews.getTitle());

        List<NewsImg> newsImgList = new ArrayList<>();
        localNews.setContent(extractVideo(spiderWechatNews.getContent(), newsImgList));
        if (!CollectionUtils.isEmpty(newsImgList)) {
            localNews.setVideoList(JSONObject.toJSONString(newsImgList));
        }
        //图片处理
        String[] imgArray = StringUtils.isEmpty(spiderWechatNews.getImgUrl()) ? null : spiderWechatNews.getImgUrl().split(";");
        localNews.setImgUrl(imgArray == null ? "" : this.toJsonString(imgArray));
        localNews.setAddress("");
        localNews.setAuthor(StringUtils.isEmpty(spiderWechatNews.getSource()) ? "匿名" : spiderWechatNews.getSource());
        localNews.setAddTime(spiderWechatNews.getCreateTime());
        if (StringUtils.isNotEmpty(spiderWechatNews.getDeployTime())) {
            localNews.setIssueTime(DateUtils.parseDateNonStrict(spiderWechatNews.getDeployTime()));
        } else {
            localNews.setIssueTime(spiderWechatNews.getCreateTime());
        }
        localNews.setStatus(LocalNewStatusEnum.ENABLE.getCode());
        localNews.setType(LocalNewsTypeEnum.NEWS.getCode());
        localNews.setTop((byte) 1);
        localNews.setKindTop((byte) 1);
        //是否是热文 1：否  2：是
        localNews.setHot((byte) 1);
        localNews.setReviewStatus((byte) 2);
        localNews.setChannel((byte) 9);
        localNews.setSource(spiderWechatNews.getSource());
        localNews.setEnablePlaceholder((long) 0);
        localNews.setDeliveryType(0);

        generateNewsStatistic(localNews);

        //保存地区
        if (StringUtil.isNotEmpty(spiderWechatNews.getRegion())) {
            localNews.setAreaDetail(spiderWechatNews.getRegion());
            localNews.setReviewStatus((byte) 0);
            localNews.setDeliveryType(1);
            logger.info("本地新闻保存-来源微信新闻->{};{}", localNews.getTitle(), localNews.getDeliveryType());
        }
        //获取种类id
        localNews.setKindId(this.getKindId(spiderWechatNews.getChannel()));
        localNews.setKindName(spiderWechatNews.getChannel());
        return localNews;
    }
}
