package com.bxm.localnews.processer;

import com.bxm.localnews.channel.DataChannelProxy;
import com.bxm.localnews.constant.ProcesserOrder;
import com.bxm.localnews.processer.impl.DefaultProcesser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProcesser implements IProcesser {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    protected DataChannelProxy dataChannelProxy;

    private IProcesser nextProcesser;

    @Override
    public IProcesser next() {
        if (null == this.nextProcesser) {
            return new DefaultProcesser();
        }
        return this.nextProcesser;
    }

    @Override
    public void setNext(IProcesser processer) {
        this.nextProcesser = processer;
    }

    @Override
    public void process(ProcesserContext context) {
        if (this.match(context.getData())) {
            if (this.execute(context)) {
                this.next().process(context);
            }
        } else {
            this.next().process(context);
        }
    }

    /**
     * 执行具体的处理逻辑
     * @param context 处理器上下文
     * @return 返回true将继续后续处理, 返回false将终止处理链
     */
    protected abstract boolean execute(ProcesserContext context);

    @Override
    public int getOrder() {
        return ProcesserOrder.get(this.getClass());
    }
}
