package com.bxm.localnews.processer;

import org.springframework.core.Ordered;

/**
 * 处理器接口
 */
public interface IProcesser extends Ordered {

    /**
     * 执行数据处理
     *
     * @param context 处理器上下文
     */
    void process(ProcesserContext context);

    /**
     * 是否对参数的数据类型进行处理
     *
     * @param data 数据对象
     * @return true表示进行匹配
     */
    boolean match(Object data);

    /**
     * 下一个处理器
     *
     * @return 处理器
     */
    IProcesser next();

    /**
     * 设置下一个处理器
     *
     * @param processer 处理器接口
     */
    void setNext(IProcesser processer);
}
