package com.bxm.localnews.processer;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 处理链，注册多个处理器，根据数据进行特定的处理行为
 */
@Component
public class ProcesserChain implements InitializingBean, ApplicationContextAware {

    private IProcesser firstProcesser;

    private ApplicationContext applicationContext;

    public void process(ProcesserContext context) {
        this.firstProcesser.process(context);
    }

    @Override
    public void afterPropertiesSet() {
        Map<String, IProcesser> processerMap = this.applicationContext.getBeansOfType(IProcesser.class);
        Collection<IProcesser> processers = processerMap.values();
        List<IProcesser> result = processers.stream().sorted(Comparator.comparingInt(Ordered::getOrder)).collect(Collectors.toList());

        for (int i = 0; i < result.size(); i++) {
            if (i == result.size() - 1) {
                break;
            }
            result.get(i).setNext(result.get(i + 1));
        }

        this.firstProcesser = result.get(0);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
