package com.bxm.localnews.processer.impl;

import com.bxm.localnews.channel.DataChannelProxy;
import com.bxm.localnews.processer.AbstractProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 优先进行更新判断，如果已经存在数据则进行更新，不进行后续处理逻辑
 */
@Component
public class ModifyProcesser extends AbstractProcesser {

    private final DataChannelProxy dataChannelProxy;

    @Autowired
    public ModifyProcesser(DataChannelProxy dataChannelProxy) {
        this.dataChannelProxy = dataChannelProxy;
    }

    @Override
    protected boolean execute(ProcesserContext context) {
        //变更返回true表示已正确变更数据，需要中止后续处理
        return !dataChannelProxy.modify(context.getData());
    }

    @Override
    public boolean match(Object data) {
        return true;
    }
}
