package com.bxm.localnews.processer.impl;

import com.bxm.localnews.processer.AbstractProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.simhash.RepeatCheckService;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.spider.SpiderNews;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 对新闻(新闻、本地新闻、微信)进行验重处理
 */
@Component
@Deprecated
public class NewsRepeatProcesser extends AbstractProcesser {

    private final RepeatCheckService repeatCheckService;

    @Autowired
    public NewsRepeatProcesser(RepeatCheckService repeatCheckService) {
        this.repeatCheckService = repeatCheckService;
    }

    @Override
    protected boolean execute(ProcesserContext context) {
        //根据SIMHASH进行新闻验重，如果是重复数据则返回false
        Object data = context.getData();
        String content = null;
        String title = null;
        Long newsId = null;
        if (data instanceof SpiderNews) {
            SpiderNews news = (SpiderNews) data;
            content = news.getContent();
            title = news.getTitle();
            newsId = news.getId();
        } else if (data instanceof SpiderWechatNews) {
            SpiderWechatNews wechatNews = (SpiderWechatNews) data;
            content = wechatNews.getContent();
            title = wechatNews.getTitle();
            newsId = wechatNews.getId();
        } else if (data instanceof News) {
            News localNews = (News) data;
            content = localNews.getContent();
            title = localNews.getTitle();
            newsId = localNews.getId();
        }
        //爬虫端已经做了去重
        //return repeatCheckService.repeatNews(newsId, title, content);
        return true;
    }

    @Override
    public boolean match(Object data) {
        return data instanceof SpiderNews || data instanceof SpiderWechatNews || data instanceof News;
    }
}
