package com.bxm.localnews.processer.impl;


import com.bxm.localnews.processer.AbstractProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.vo.local.AdminNews;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import com.bxm.localnews.sync.vo.local.NewsStatus;
import com.bxm.localnews.sync.vo.spider.SpiderCouponGoods;
import com.bxm.localnews.sync.vo.spider.SpiderForumPost;
import org.springframework.stereotype.Component;

/**
 * 如果原始数据已移除，指定对应的删除处理
 */
@Component
public class RemoveProcesser extends AbstractProcesser {

    @Override
    protected boolean execute(ProcesserContext context) {
        if (context.getData().getStatus() == 0 || context.getData().getStatus() == 2) {
            dataChannelProxy.remove(context.getData());
            return false;
        }
        return true;
    }

    @Override
    public boolean match(Object data) {
        if(data instanceof SpiderCouponGoods) return false;
        if(data instanceof NewsRecommended) return false;
        if(data instanceof NewsStatistics) return false;
        if(data instanceof AdminNews) return false;
        if(data instanceof NewsStatus) return false;
        if (data instanceof SpiderForumPost) return false;
        return true;
    }
}
