package com.bxm.localnews.processer.impl;

import com.bxm.localnews.analysis.TFIDFAnalyzesService;
import com.bxm.localnews.processer.AbstractProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.spider.SpiderVideo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 小视频关键特征提取处理器
 */
@Component
public class VideoKeywordProcesser extends AbstractProcesser {

    private final TFIDFAnalyzesService tfidfAnalyzesService;

    @Autowired
    public VideoKeywordProcesser(TFIDFAnalyzesService tfidfAnalyzesService) {
        this.tfidfAnalyzesService = tfidfAnalyzesService;
    }

    @Override
    protected boolean execute(ProcesserContext context) {
        SpiderVideo video = (SpiderVideo) context.getData();
        List<Keyword> keywordList = this.tfidfAnalyzesService.analyze(video.getTitle(), video.getDesc(), 5);
        video.setKeywordList(keywordList);
        return true;
    }

    @Override
    public boolean match(Object data) {
        return data instanceof SpiderVideo;
    }
}
