package com.bxm.localnews.service;


import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.second.dao.SpiderCouponGoodsMapper;
import com.bxm.localnews.sync.vo.spider.SpiderCouponGoods;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 优惠卷同步
 */
@Component
public class CouponService extends BaseService {

    private final RedisStringAdapter redisStringAdapter;

    private final SpiderCouponGoodsMapper spiderCouponGoodsMapper;

    private final ProcesserChain processerChain;

    @Autowired
    public CouponService(RedisStringAdapter redisStringAdapter,
                         SpiderCouponGoodsMapper spiderCouponGoodsMapper,
                         ProcesserChain processerChain
    ) {
        this.redisStringAdapter = redisStringAdapter;
        this.spiderCouponGoodsMapper = spiderCouponGoodsMapper;
        this.processerChain = processerChain;
    }

    public void sync() {
        Date lastSyncTime = this.redisStringAdapter.get(RedisKey.SPIDER_COUPON_SYNC, Date.class);

        if (null == lastSyncTime) {
            //初始从14天前开始拉取
            Calendar calendar = Calendar.getInstance();
            calendar.add(Calendar.DAY_OF_YEAR, -14);
            lastSyncTime = calendar.getTime();
        }

        this.execute(lastSyncTime);
    }

    private void execute(Date limitDate) {
        List<SpiderCouponGoods> list = this.spiderCouponGoodsMapper.listForSync(limitDate, BigDecimal.valueOf(9.90),(byte) 1);

        if (list == null || list.isEmpty()) {
            return;
        }

        for (SpiderCouponGoods spiderCouponGoods : list) {
            ProcesserContext<SpiderCouponGoods> context = new ProcesserContext<>();
            context.setData(spiderCouponGoods);
            this.processerChain.process(context);
        }

        SpiderCouponGoods spiderCouponGoods = list.get(list.size() - 1);
        this.redisStringAdapter.set(RedisKey.SPIDER_COUPON_SYNC, spiderCouponGoods.getModifyTime());
        this.execute(spiderCouponGoods.getModifyTime());

    }


}
