package com.bxm.localnews.service;

import java.io.*;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.bxm.localnews.config.SyncProperties;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.primary.dao.VideoFetchKeywordMapper;
import com.bxm.localnews.sync.vo.local.RepeatData;
import com.bxm.localnews.sync.vo.local.VideoFetchKeyword;
import com.bxm.localnews.sync.vo.spider.IDataVideo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/**
 * @author zhaoyadong 2018/12/11 17:04
 * @desc
 */
@Component
@Deprecated
public class IDataVideoServie {

    private static final Logger logger = LoggerFactory.getLogger(IDataVideoServie.class);

    private final RedisStringAdapter redisStringAdapter;

    private VideoFetchKeywordMapper videoFetchKeywordMapper;

    private SyncProperties syncProperties;

    private ProcesserChain processerChain;

    private RedisSetAdapter redisSetAdapter;

    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public IDataVideoServie(RedisStringAdapter redisStringAdapter, RedisSetAdapter redisSetAdapter,
                            RedisHashMapAdapter redisHashMapAdapter, VideoFetchKeywordMapper videoFetchKeywordMapper,
                            SyncProperties syncProperties, ProcesserChain processerChain) {
        this.redisStringAdapter = redisStringAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.videoFetchKeywordMapper = videoFetchKeywordMapper;
        this.syncProperties = syncProperties;
        this.processerChain = processerChain;
    }

    private static String readAll(Reader rd) throws IOException {
        StringBuilder sb = new StringBuilder();
        int cp;
        while ((cp = rd.read()) != -1) {
            sb.append((char) cp);
        }
        return sb.toString();
    }

    private static JSONObject postRequestFromUrl(String url, String body) throws IOException {
        URL realUrl = new URL(url);
        URLConnection conn = realUrl.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        PrintWriter out = new PrintWriter(conn.getOutputStream());
        out.print(body);
        out.flush();

        InputStream instream = conn.getInputStream();
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(instream, Charset.forName("UTF-8")));
            String jsonText = readAll(rd);
            JSONObject json = JSON.parseObject(jsonText);
            return json;
        } finally {
            instream.close();
        }
    }

    private static JSONObject getRequestFromUrl(String url) throws IOException {
        URL realUrl = new URL(url);
        URLConnection conn = realUrl.openConnection();
        InputStream instream = conn.getInputStream();
        try {
            BufferedReader rd = new BufferedReader(new InputStreamReader(instream, Charset.forName("UTF-8")));
            String jsonText = readAll(rd);
            JSONObject json = JSON.parseObject(jsonText);
            return json;
        } finally {
            instream.close();
        }
    }

    public void sync() {
        Date date = new Date();
        List<VideoFetchKeyword> list = videoFetchKeywordMapper.getAllList();
        List<IDataVideo> iDataVideoList = Lists.newArrayList();
        //List<IDataVideo> douYinList = Lists.newArrayList();
        List<IDataVideo> meiPaiList = Lists.newArrayList();
        List<IDataVideo> miaopaiList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(list)) {
            for (VideoFetchKeyword v : list) {
                try {
                    //douYinList.addAll(syncDouyinVideo(v));
                    //Thread.sleep(1000);
                    meiPaiList.addAll(syncMeiPaiVideo(v));
                    Thread.sleep(1000);
                    miaopaiList.addAll(syncMiaoPaiVideo(v));
                } catch (InterruptedException e) {
                    logger.error("当前线程[{}]同步视频异常", e.getMessage());
                }
            }
        }
        String key = DateUtils.formatAtWill(date, "yyyyMMddHH");
        //iDataVideoList.addAll(repeatIDataVideo(douYinList, 1, key));
        iDataVideoList.addAll(repeatIDataVideo(meiPaiList, 2, key));
        iDataVideoList.addAll(repeatIDataVideo(miaopaiList, 3, key));
        logger.info("当前需要同步的视频长度为：[{}]", iDataVideoList.size());
        this.excute(iDataVideoList);
    }

    /**
     * 同步抖音视频
     *
     * @param v
     */
    private List<IDataVideo> syncDouyinVideo(VideoFetchKeyword v) {
        HashMap<String, String> map = Maps.newHashMap();
        map.put("apikey", syncProperties.getVideoApiKey());
        map.put("kw", v.getName());
        String apiUrl = syncProperties.getDouyinApi();

        List<IDataVideo> list = getVideo(apiUrl, map, v, "抖音");
        addValueToVideoList(list);
        return list;
    }

    /**
     * 同步美拍视频
     *
     * @param v
     */
    private List<IDataVideo> syncMeiPaiVideo(VideoFetchKeyword v) {
        HashMap<String, String> map = Maps.newHashMap();
        map.put("apikey", syncProperties.getVideoApiKey());
        map.put("kw", v.getName());
        String apiUrl = syncProperties.getMeipaiApi();

        List<IDataVideo> list = getVideo(apiUrl, map, v, "美拍");
        addValueToVideoList(list);
        return list;
    }

    /**
     * 同步秒拍视频
     *
     * @param v
     */
    private List<IDataVideo> syncMiaoPaiVideo(VideoFetchKeyword v) {
        HashMap<String, String> map = Maps.newHashMap();
        map.put("apikey", syncProperties.getVideoApiKey());
        map.put("kw", v.getName());
        String apiUrl = syncProperties.getMiaopaiApi();

        List<IDataVideo> list = getVideo(apiUrl, map, v, "秒拍");
        addValueToVideoList(list);
        return list;

    }

    /**
     * 为抓取的视频列表赋值
     *
     * @param list
     */
    private void addValueToVideoList(List<IDataVideo> list) {

        list.forEach(dataVideo -> {
            String videoId = dataVideo.getId();
            dataVideo.setVideoId(videoId);
            dataVideo.setId(getVideoId().toString());
            dataVideo.setStatus((byte) 1);
        });
    }

    /**
     * 插入数据
     *
     * @param list
     */
    private void excute(List<IDataVideo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }

        for (IDataVideo dataVideo : list) {
            ProcesserContext<IDataVideo> context = new ProcesserContext<>();
            context.setData(dataVideo);
            this.processerChain.process(context);
        }
    }

    /**
     * 去除重复的视频
     *
     * @param list
     * @param videoType
     * @param key
     * @return
     */
    private List<IDataVideo> repeatIDataVideo(List<IDataVideo> list, int videoType, String key) {
        List<IDataVideo> dataVideoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return dataVideoList;
        }
        Set<String> stringSet;
        String[] array;
        Date date;
        List<String> repeatDatas = Lists.newArrayList();
        switch (videoType) {
            case 1:
                stringSet = redisSetAdapter.getAllMembers(getDouYinVideoListKey(), String.class);

                list.forEach(iDataVideo -> {
                    if (!stringSet.contains(iDataVideo.getVideoId())) {
                        dataVideoList.add(iDataVideo);
                        stringSet.add(iDataVideo.getVideoId());
                    } else {
                        logger.info("爬取的抖音视频id为[{}]----本地存入的视频title为[{}]和description为[{}]重复", iDataVideo.getVideoId(),
                                iDataVideo.getTitle(), iDataVideo.getDescription());
                        repeatDatas.add(iDataVideo.getVideoId());
                    }
                });
                array = stringSet.stream()
                        .toArray(String[]::new);
                redisSetAdapter.add(getDouYinVideoListKey(), array);

                date = new Date();
                RepeatData repeatData = new RepeatData(date, Long.valueOf(list.size()), Long.valueOf(repeatDatas.size()),
                        Long.valueOf(stringSet.size()));
                redisHashMapAdapter.put(getRepeatKey(videoType), key, repeatData);
                break;
            case 2:
                stringSet = redisSetAdapter.getAllMembers(getMeipaiVideoListKey(), String.class);
                list.forEach(iDataVideo -> {
                    if (!stringSet.contains(iDataVideo.getVideoId())) {
                        dataVideoList.add(iDataVideo);
                        stringSet.add(iDataVideo.getVideoId());
                    } else {
                        logger.info("爬取的美拍视频id为[{}]----本地存入的视频title为[{}]和description为[{}]重复", iDataVideo.getVideoId(),
                                iDataVideo.getTitle(), iDataVideo.getDescription());
                        repeatDatas.add(iDataVideo.getVideoId());
                    }
                });
                array = stringSet.stream()
                        .toArray(String[]::new);
                redisSetAdapter.add(getMeipaiVideoListKey(), array);

                date = new Date();
                repeatData = new RepeatData(date, Long.valueOf(list.size()), Long.valueOf(repeatDatas.size()),
                        Long.valueOf(stringSet.size()));
                redisHashMapAdapter.put(getRepeatKey(videoType), key, repeatData);
                break;
            case 3:
                stringSet = redisSetAdapter.getAllMembers(getMiaoPaiVideoListKey(), String.class);
                list.forEach(iDataVideo -> {
                    if (!stringSet.contains(iDataVideo.getVideoId())) {
                        dataVideoList.add(iDataVideo);
                        stringSet.add(iDataVideo.getVideoId());
                    } else {
                        logger.info("爬取的秒拍视频id为[{}]----本地存入的视频title为[{}]和description为[{}]重复", iDataVideo.getVideoId(),
                                iDataVideo.getTitle(), iDataVideo.getDescription());
                        repeatDatas.add(iDataVideo.getVideoId());
                    }
                });
                array = stringSet.stream()
                        .toArray(String[]::new);
                redisSetAdapter.add(getMiaoPaiVideoListKey(), array);

                date = new Date();
                repeatData = new RepeatData(date, Long.valueOf(list.size()), Long.valueOf(repeatDatas.size()),
                        Long.valueOf(stringSet.size()));
                redisHashMapAdapter.put(getRepeatKey(videoType), key, repeatData);

                break;
            default:
                break;
        }

        return dataVideoList;
    }

    /**
     * 同步视频并解析视频信息
     *
     * @param apiUrl
     * @param map
     * @param v
     * @param videoType
     * @return
     */
    private List<IDataVideo> getVideo(String apiUrl, HashMap<String, String> map, VideoFetchKeyword v, String videoType) {
        List<IDataVideo> list = Lists.newArrayList();
        TypeReference<List<IDataVideo>> typeReference = new TypeReference<List<IDataVideo>>() {
        };
        String url = generateUrl(apiUrl, map);
        try {
            JSONObject json = getRequestFromUrl(url);
            if (StringUtils.isEmpty(json)) {
                return list;
            }
            if (isRequestSuccess(json)) {
                try {
                    JSONArray jsonArray = json.getJSONArray("data");
                    List<IDataVideo> jsonList = JSONObject.parseObject(jsonArray.toJSONString(), typeReference);
                    list.addAll(jsonList);
                    String pageToken = json.getString("pageToken");
                    if (!StringUtils.isEmpty(pageToken)) {
                        map.put("pageToken", json.getString("pageToken"));
                        url = generateUrl(apiUrl, map);
                        try {
                            Thread.sleep(1000);
                            json = getRequestFromUrl(url);
                            if (isRequestSuccess(json)) {
                                try {
                                    jsonArray = json.getJSONArray("data");
                                    jsonList = JSONObject.parseObject(jsonArray.toJSONString(), typeReference);
                                    list.addAll(jsonList);
                                } catch (Exception e) {
                                    logger.error("第二次同步[{}]视频--关键字id为[{}], 名称为[{}]获取的json数据解析异常", videoType, v.getId(), v.getName());
                                    logger.error(e.getMessage(), e);
                                }
                            }
                        } catch (Exception e) {
                            logger.error("获取下一页同步视频[{}]对应关键字的id为[{}], 名称为[{}]发生错误", videoType, v.getId(), v.getName());
                            logger.error(e.getMessage(), e);
                        }
                    }
                } catch (Exception e) {
                    logger.error("[{}]视频--关键字id为[{}], 名称为[{}]获取的json数据解析异常", videoType, v.getId(), v.getName());
                    logger.error(e.getMessage(), e);
                }
            }
        } catch (Exception e) {
            logger.error("同步视频[{}]对应关键字的id为[{}], 名称为[{}]发生错误", videoType, v.getId(), v.getName());
            logger.error(e.getMessage(), e);
        }

        return list;
    }

    /**
     * 判断请求是否成功
     *
     * @param jsonObject
     * @return
     */
    private boolean isRequestSuccess(JSONObject jsonObject) {
        String retCode = jsonObject.getString("retcode");
        return retCode.equals("000000") || retCode.equals("0");
    }

    /**
     * 生成访问的API
     *
     * @return
     */
    private String generateUrl(String url, HashMap<String, String> map) {
        String params = Joiner.on("&").withKeyValueSeparator("=").join(map);
        logger.info("当前同步的api地址为：[{}]", url + "?" + params);
        return new StringBuilder().append(url)
                .append("?").append(params).toString();
    }

    /**
     * 获取videoId
     *
     * @return
     */
    private Long getVideoId() {
        if (!redisStringAdapter.hasKey(getMaxVideoIdKey())) {
            redisStringAdapter.set(getMaxVideoIdKey(), 5000000000L);
            return 5000000000L;
        }
        return redisStringAdapter.increment(getMaxVideoIdKey());
    }

    /**
     * 获取最大的videoId
     *
     * @return
     */
    private KeyGenerator getMaxVideoIdKey() {
        return DefaultKeyGenerator.build("sync", "video").copy().appendKey("max_id");
    }

    /**
     * 获取抖音同步的视频id——list
     *
     * @return
     */
    private KeyGenerator getDouYinVideoListKey() {
        return DefaultKeyGenerator.build("sync", "video").copy().appendKey("douyin_list");
    }

    /**
     * 获取秒拍同步的视频id——list
     *
     * @return
     */
    private KeyGenerator getMiaoPaiVideoListKey() {
        return DefaultKeyGenerator.build("sync", "video").copy().appendKey("miaopai_list");
    }

    /**
     * 获取美拍同步的视频id——list
     *
     * @return
     */
    private KeyGenerator getMeipaiVideoListKey() {
        return DefaultKeyGenerator.build("sync", "video").copy().appendKey("meipai_list");
    }

    /**
     * 获取存放重复数据的key
     *
     * @param videoType
     * @return
     */
    private KeyGenerator getRepeatKey(int videoType) {
        return DefaultKeyGenerator.build("sync", "video").copy().appendKey(videoType);
    }
}
