package com.bxm.localnews.service;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.sync.primary.dao.ForumPostMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.third.dao.UserMapper;
import com.bxm.localnews.sync.vo.business.User;
import com.bxm.localnews.sync.vo.business.UserStatistic;
import com.bxm.newidea.component.service.BaseService;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 用户静态数据定时更新
 */
@Component
public class UserStatisticService extends BaseService {

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private UserReplyMapper userReplyMapper;

    @Autowired
    private UserMapper userMapper;

    @Autowired
    @Qualifier("thirdSessionTemplate")
    private SqlSessionTemplate thirdSessionTemplate;

    public void sync(List<Long> idList, Integer offset) {
        String tableName = "a_user_reply_" + offset;
        List<UserStatistic> userStatisticList = new ArrayList<>();

        for (Long id : idList) {
            // 计算用户发布的评论数
            int userReplyCount = userReplyMapper.calculateReplyNumByUser(tableName, id);
            // 计算用户发布的贴子数
            int userPostCount = forumPostMapper.calculatePostNumByUser(id);
            // 组装数据
            UserStatistic userStatistic = new UserStatistic(id, userPostCount, userReplyCount);
            userStatisticList.add(userStatistic);
        }
        //批量更新用户的评论发布数和帖子发布数
        MybatisBatchBuilder.create(UserMapper.class, userStatisticList).sessionTemplate(thirdSessionTemplate).run(UserMapper::updateUserStatistic);

    }

    public User getUserInfo(Map<Long, User> userMap, Long userId){
        User user;
        if (userMap.get(userId) != null) {
            user = userMap.get(userId);
        } else {
            user = userMapper.selectUserById(userId);
            userMap.put(userId, user);
        }
        return user;
    }

}
