package com.bxm.localnews.service;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.second.dao.SpiderWechatNewsMapper;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * 微信公众号新闻同步
 * @author zhaoyadong 2018/11/20 14:31
 */
@Component
public class WechatNewsSyncService extends BaseService {

    private static final Logger logger = LoggerFactory.getLogger(WechatNewsSyncService.class);

    private final SpiderWechatNewsMapper spiderWechatNewsMapper;

    private final RedisStringAdapter redisStringAdapter;

    private final ProcesserChain processerChain;

    @Autowired
    public WechatNewsSyncService(SpiderWechatNewsMapper spiderWechatNewsMapper,
                                 RedisStringAdapter redisStringAdapter,
                                 ProcesserChain processerChain) {
        this.spiderWechatNewsMapper = spiderWechatNewsMapper;
        this.redisStringAdapter = redisStringAdapter;
        this.processerChain = processerChain;
    }

    public void sync() {
        Date lastSyncTime = this.redisStringAdapter.get(RedisKey.SPIDER_WECHAT_SYNC, Date.class);
        if (null == lastSyncTime) {
            Calendar calendar = Calendar.getInstance();
            //初始从14天前开始拉取
            calendar.add(Calendar.DAY_OF_YEAR, -14);
            lastSyncTime = calendar.getTime();
        }

        this.execute(lastSyncTime);
    }

    private void execute(Date limitDate) {
        List<SpiderWechatNews> list = this.spiderWechatNewsMapper.listForSync(limitDate);

        if (list == null || list.isEmpty()) {
            logger.debug("list empty return;");
            return;
        }

        for (SpiderWechatNews wechatNews : list) {
            wechatNews.setContent(this.spiderWechatNewsMapper.findById(wechatNews.getId()));
            ProcesserContext<SpiderWechatNews> context = new ProcesserContext<>();
            context.setData(wechatNews);
            this.processerChain.process(context);
        }

        SpiderWechatNews wechatNews = list.get(list.size() - 1);
        this.redisStringAdapter.set(RedisKey.SPIDER_WECHAT_SYNC, wechatNews.getModifyTime());

        this.execute(wechatNews.getModifyTime());
    }
}
