package com.bxm.localnews.service.impl;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.service.CommonTagService;
import com.bxm.localnews.sync.primary.dao.CommonTagMapper;
import com.bxm.localnews.sync.vo.local.CommonTag;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Log4j2
@Service
public class CommonTagServiceImpl implements CommonTagService {


    private final CommonTagMapper commonTagMapper;

    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public CommonTagServiceImpl(CommonTagMapper commonTagMapper,
                                RedisHashMapAdapter redisHashMapAdapter) {
        this.commonTagMapper = commonTagMapper;
        this.redisHashMapAdapter = redisHashMapAdapter;
    }

    @Override
    public long saveAndGetTag(String tagName) {
        long hashCode = tagName.hashCode();

        long collectionIndex = hashCode % 10;
        KeyGenerator tagKey = RedisKey.SPIDER_TAG_INDEX.copy().appendKey(collectionIndex);

        Long id = redisHashMapAdapter.get(tagKey, tagName, Long.class);
        if (null == id) {
            //id使用数据库自增 需用作坐标计算 不可以无序切过大
            CommonTag tag = commonTagMapper.findByName(tagName);
            if(tag==null) {
                tag = new CommonTag();
                tag.setName(tagName);
                if (log.isDebugEnabled()){
                    log.debug("tag:[{}]",tag);
                }
                commonTagMapper.insert(tag);

            }
            redisHashMapAdapter.put(tagKey, tagName, tag.getId());
            return tag.getId();
        }

        return id;
    }
}
