package com.bxm.localnews.service.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.service.NewsInfoSyncService;
import com.bxm.localnews.service.UserStatisticService;
import com.bxm.localnews.sync.primary.dao.NewsInfoSyncMapper;
import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.primary.dao.NewsReplyMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.vo.business.NewsCommentStatistic;
import com.bxm.localnews.sync.vo.business.User;
import com.bxm.localnews.sync.vo.local.ForumPostStatic;
import com.bxm.localnews.sync.vo.local.NewsReply;
import com.bxm.localnews.thread.NewsCommentSyncThread;
import com.google.common.collect.Lists;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;

/**
 * @author pengchangqi
 * @Date 2019/4/22
 */
@Service
public class NewsInfoSyncServiceImpl implements NewsInfoSyncService {
    private static CountDownLatch countDownLatch = null;

    private static final String primarySessionTemplate = "primarySessionTemplate";

    @Resource
    private NewsInfoSyncMapper newsInfoSyncMapper;

    @Resource
    private NewsReplyMapper newsReplyMapper;

    @Resource
    private UserReplyMapper userReplyMapper;

    @Resource
    private UserStatisticService userStatisticService;

    @Resource
    private NewsMapper newsMapper;

    @Resource
    private AsyncTaskExecutor taskExecutor;

    @Override
    public void execute() {
        //收藏数同步
        List<Long> collectPostIds = newsInfoSyncMapper.selectCollectPost();
        List<ForumPostStatic> collects = Lists.newArrayList();
        for (Long postid : collectPostIds) {
            ForumPostStatic postStatic = new ForumPostStatic();
            postStatic.setPostId(postid);
            postStatic.setCollectCount(newsInfoSyncMapper.selectCollectByPostId(postid));
            collects.add(postStatic);
        }
        if (!CollectionUtils.isEmpty(collects)){
            MybatisBatchBuilder.create(NewsInfoSyncMapper.class, collects).sessionTemplateName(primarySessionTemplate).limit(500).run(NewsInfoSyncMapper::updateForumPostStaticById);
        }


        //分享数同步
        List<Long> sharePostIds = newsInfoSyncMapper.selectSharePostCountNum();
        List<ForumPostStatic> shares = Lists.newArrayList();
        for (Long postid : sharePostIds) {
            ForumPostStatic postStatic = new ForumPostStatic();
            postStatic.setPostId(postid);
            postStatic.setShareCount(newsInfoSyncMapper.selectShareCountByPostId(postid));
            shares.add(postStatic);
        }
        if (!CollectionUtils.isEmpty(shares)){
            MybatisBatchBuilder.create(NewsInfoSyncMapper.class, shares).sessionTemplateName(primarySessionTemplate).limit(500).run(NewsInfoSyncMapper::updateForumPostStaticById);
        }


        //点赞数同步
        List<Long> likePostIds = newsInfoSyncMapper.selectLikePostCountNum();
        List<ForumPostStatic> likes = Lists.newArrayList();
        for (Long postid : likePostIds) {
            ForumPostStatic postStatic = new ForumPostStatic();
            postStatic.setPostId(postid);
            postStatic.setLikeCount(newsInfoSyncMapper.selectLikeCountByPostId(postid));
            likes.add(postStatic);
        }
        if (!CollectionUtils.isEmpty(likes)){
            MybatisBatchBuilder.create(NewsInfoSyncMapper.class, likes).sessionTemplateName(primarySessionTemplate).limit(500).run(NewsInfoSyncMapper::updateForumPostStaticById);
        }

    }

    @Override
    public void syncNewsComment(List<Long> idList, Integer offset) {
        String tableName = "t_news_reply_" + offset;
        List<NewsCommentStatistic> newsCommentStatisticList = new ArrayList<>();
        for (Long id : idList) {
            int newsCommentCount = newsInfoSyncMapper.selectNewsCommentCount(tableName, id);
            NewsCommentStatistic newsCommentStatistic = new NewsCommentStatistic(id, newsCommentCount);
            newsCommentStatisticList.add(newsCommentStatistic);
        }
        MybatisBatchBuilder.create(NewsMapper.class, newsCommentStatisticList).sessionTemplateName(primarySessionTemplate).limit(500).run(NewsMapper::updateNewsCommentById);

    }

    @Override
    public void syncNewsReply() {
        Map<Long, User> userMap = new HashMap<>();

        //评论表更新
        List<NewsReply> waitForUpdateNewsReplyList = new ArrayList<>();
        List<NewsReply> newsReplyList = newsReplyMapper.selectWithoutUser();
        for (NewsReply newsReply:newsReplyList) {
            User user = userStatisticService.getUserInfo(userMap, newsReply.getUserId());
            if (Objects.nonNull(user)){
                newsReply.setUserNickname(user.getNickname());
                newsReply.setHeadImg(user.getHeadImg());
            }
            if (newsReply.getParentUserId()!=null) {
                User parentUser = userStatisticService.getUserInfo(userMap, newsReply.getParentUserId());
                if (Objects.nonNull(parentUser)) {
                    newsReply.setParentUserNickname(parentUser.getNickname());
                    newsReply.setParentHeadImg(parentUser.getHeadImg());
                }
            }
            if (!(StringUtils.isEmpty(newsReply.getParentUserNickname())
                    && StringUtils.isEmpty(newsReply.getParentHeadImg())
                    && StringUtils.isEmpty(newsReply.getUserNickname())
                    && StringUtils.isEmpty(newsReply.getHeadImg()))) {
                waitForUpdateNewsReplyList.add(newsReply);
            }
        }

        MybatisBatchBuilder.create(NewsReplyMapper.class, waitForUpdateNewsReplyList).sessionTemplateName(primarySessionTemplate).run(NewsReplyMapper::updateUserInfo);
        MybatisBatchBuilder.create(UserReplyMapper.class, waitForUpdateNewsReplyList).sessionTemplateName(primarySessionTemplate).run(UserReplyMapper::updateUserInfo);
    }

    @Async
    @Override
    public void syncNewsComment() {
        if (countDownLatch == null || countDownLatch.getCount() == 0) {
            List<Long> idList = newsMapper.getNewsIdByIssueTime();
            /**
             * 分表总数
             */
            int tableTotal = 10;
            countDownLatch = new CountDownLatch(tableTotal);
            for (int i = 0; i < tableTotal; i++) {
                int finalI = i;
                List<Long> filterIdList;
                filterIdList = idList.stream().filter(x -> (x % 10) == finalI).collect(Collectors.toList());

                this.taskExecutor.execute(new NewsCommentSyncThread().build(i, filterIdList, countDownLatch));
            }
        }
    }
}
