package com.bxm.localnews.service.impl;

import com.bxm.localnews.service.UserRecommendService;
import com.bxm.localnews.sync.dto.RecommendNativeDTO;
import com.bxm.localnews.sync.service.UserIntegrationService;
import com.bxm.localnews.sync.third.dao.RecommendNativeMapper;
import com.bxm.localnews.sync.vo.business.RecommendNative;
import com.bxm.newidea.component.uuid.SequenceCreater;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;

@Service
@Slf4j
public class UserRecommendServiceImpl implements UserRecommendService {

    @Autowired
    private RecommendNativeMapper recommendNativeMapper;

    @Autowired
    private SequenceCreater sequenceCreater;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Override
    public Boolean updateUserAttribute(RecommendNativeDTO recommendNativeDTO) {

        if (!checkInfo(recommendNativeDTO.getUserId())) {
            log.error("该用户非正常用户:{},不进行用户推荐数据源同步", recommendNativeDTO.getUserId());
            return true;
        }
        RecommendNative recommendNativeEntity = new RecommendNative();
        BeanUtils.copyProperties(recommendNativeDTO, recommendNativeEntity);

        RecommendNative resultByUserId = recommendNativeMapper.selectByUserId(recommendNativeEntity.getUserId());
        if (null == resultByUserId) {
            //若无数据则初始化-新添用户的默认position数据
            if (!initUserRecommendInfo(recommendNativeDTO.getUserId())) {
                //初始化失败则return
                return true;
            }
        }

        recommendNativeMapper.updateAttribute(recommendNativeEntity);
        return true;
    }

    @Override
    public Boolean updateUserBehavior(RecommendNativeDTO recommendNativeDTO) {
        if (!checkInfo(recommendNativeDTO.getUserId())) {
            log.error("该用户非正常用户:{},不进行用户推荐数据源同步", recommendNativeDTO.getUserId());
            return true;
        }

        RecommendNative recommendNativeEntity = new RecommendNative();
        BeanUtils.copyProperties(recommendNativeDTO, recommendNativeEntity);


        RecommendNative resultByUserId = recommendNativeMapper.selectByUserId(recommendNativeEntity.getUserId());
        if (null == resultByUserId) {
            //若无数据则初始化-新添用户的默认position数据
            if (!initUserRecommendInfo(recommendNativeDTO.getUserId())) {
                //初始化失败则return
                return true;
            }
        }
        recommendNativeMapper.updateBehavior(recommendNativeEntity);
        return true;
    }

    @Override
    public Boolean updateUserPosition(RecommendNativeDTO recommendNativeDTO) {
        if (!checkInfo(recommendNativeDTO.getUserId())) {
            log.error("该用户非正常用户:{},不进行用户推荐数据源同步", recommendNativeDTO.getUserId());
            return true;
        }
        RecommendNative recommendNativeEntity = new RecommendNative();
        recommendNativeEntity.setUserId(recommendNativeDTO.getUserId());
        recommendNativeEntity.setLongitude(new BigDecimal(recommendNativeDTO.getLongitude()));
        recommendNativeEntity.setLatitude(new BigDecimal(recommendNativeDTO.getLatitude()));
        recommendNativeEntity.setCurrentAreaCode(recommendNativeDTO.getCurrentAreaCode());

        RecommendNative resultByUserId = recommendNativeMapper.selectByUserId(recommendNativeEntity.getUserId());
        if (null == resultByUserId) {
            //若无数据则初始化-新添用户的默认position数据
            if (!initUserRecommendInfo(recommendNativeDTO.getUserId())) {
                //初始化失败则return
                return true;
            }
        }
        //更新
        recommendNativeMapper.updatePosition(recommendNativeEntity);
        return true;
    }

    /**
     * 检验消息可用性,true可用,false不可用
     * @param userId 用户id
     * @return 消息可用性 true可用,false不可用
     */
    private boolean checkInfo(Long userId) {
        //查询用户是否是有效用户,若不是有效用户则不进行数据同步
        return userIntegrationService.isNormalUser(userId);
    }

    /**
     * 初始化用户推荐信息-保证用户的初始化数据有默认的position信息
     * @param userId 用户id
     * @return true 初始化成功  false失败
     */
    private boolean initUserRecommendInfo(Long userId) {
        RecommendNative recommendNativeEntity = new RecommendNative();
        recommendNativeEntity.setId(sequenceCreater.nextLongId());
        recommendNativeEntity.setUserId(userId);
        //设置默认的position为北京
        recommendNativeEntity.setLongitude(new BigDecimal("116.407526"));
        recommendNativeEntity.setLatitude(new BigDecimal("39.90403"));

        return recommendNativeMapper.initUserRecommendInfo(recommendNativeEntity) > 0;

    }
}
