package com.bxm.localnews.task;

import com.bxm.localnews.service.NewsCleanService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class CleanNewsTask extends AbstractCronTask<String> {

    @Resource
    private NewsCleanService newsCleanService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("开始定时清理新闻! 当前时间：{}", new Date());
        newsCleanService.clean();
        log.info("结束定时清理新闻! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "cleanNewsTask";
    }

    @Override
    public String cron() {
        return "0 0 3 * * ?";
    }

    @Override
    public String description() {
        return "新闻推荐池定期清理任务";
    }

}
