package com.bxm.localnews.task;

import com.bxm.localnews.service.NewsStatisticService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class ConsumeNewsStatisticTask extends AbstractCronTask<String> {

    @Resource
    private NewsStatisticService newsStatisticService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("开始消费新闻静态数据！当前时间：{}", new Date());
        newsStatisticService.sync();
        log.info("结束消费新闻静态数据! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "consumeNewsStatisticTask";
    }

    @Override
    public String cron() {
        return "0 0/5 * * * ?";
    }

    @Override
    public String description() {
        return "消费新闻静态数据，阅读数增加，分享数增加等";
    }

}
