package com.bxm.localnews.task;

import com.bxm.localnews.service.CouponService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class SyncCouponTask extends AbstractCronTask<String> {

    @Resource
    private CouponService couponService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("开始同步优惠券数据! 当前时间：{}", new Date());
        couponService.sync();
        log.info("结束同步优惠券数据! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncCouponTask";
    }

    @Override
    public String cron() {
        return "0 0/10 * * * ?";
    }

    @Override
    public String description() {
        return "优惠券同步任务";
    }

}
