package com.bxm.localnews.task;

import com.bxm.localnews.service.ForumPostService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 同步爬虫抓取的帖子
 */
//@Component
@Slf4j
public class SyncForumPostTask extends AbstractCronTask<String> {

    @Autowired
    ForumPostService forumPostService;

    @Override
    public ReturnT<String> service(String s) {
        log.info("开始同步帖子! 当前时间：{}", new Date());
        forumPostService.syncPost();
        log.info("结束同步帖子! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;

    }

    @Override
    public String taskName() {
        return "syncForumPost";
    }

    @Override
    public String cron() {
        return "0 0/6 * * * ?";
    }

    @Override
    public String description() {
        return "帖子同步任务";
    }
}
