package com.bxm.localnews.task;

import com.bxm.localnews.service.NewsInfoSyncService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class SyncNewsCommentTask extends AbstractCronTask<String> {

    @Resource
    private NewsInfoSyncService newsInfoSyncService;

    @Override
    public ReturnT<String> service(String param) {
        log.info("开始同步新闻评论数! 当前时间：{}", new Date());
        newsInfoSyncService.syncNewsComment();
        log.info("结束同步新闻评论数! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncNewsCommentTask";
    }

    @Override
    public String cron() {
        return "0 0 5 * * ?";
    }

    @Override
    public String description() {
        return "新闻评论同步";
    }

}
