package com.bxm.localnews.task;

import com.bxm.localnews.service.NewsInfoSyncService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class SyncNewsStatisticTask extends AbstractCronTask<String> {

    @Resource
    private NewsInfoSyncService newsInfoSyncService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("开始同步新闻静态数据! 当前时间：{}", new Date());
        newsInfoSyncService.execute();
        log.info("结束同步新闻静态数据! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncNewsStatisticTask";
    }

    @Override
    public String cron() {
        return "0 0 3 * * ?";
    }

    @Override
    public String description() {
        return "更新小视频/帖子的评论数,分享数,收藏数";
    }

}
