package com.bxm.localnews.task;

import com.bxm.localnews.service.ForumPostService;
import com.bxm.localnews.service.NewsInfoSyncService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class SyncUserRedundancyInfoTask extends AbstractCronTask<String> {

    @Resource
    private ForumPostService forumPostService;

    @Resource
    private NewsInfoSyncService newsInfoSyncService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("开始修正用户冗余数据! 当前时间：{}", new Date());

        /**
         * 帖子表或者帖子点赞表中有出现空用户的
         */
        forumPostService.scanningForumPost();

        /**
         * 评论表中有出现空用户的
         */
        newsInfoSyncService.syncNewsReply();

        log.info("结束修正用户冗余数据! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncUserRedundancyInfoTask";
    }

    @Override
    public String cron() {
        return "0 0/50 * * * ?";
    }

    @Override
    public String description() {
        return "用户冗余数据同步任务";
    }

}
