package com.bxm.localnews.task;

import com.bxm.localnews.service.VideoSyncService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class SyncVideoTask extends AbstractCronTask<String> {

    @Resource
    private VideoSyncService videoSyncService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("开始同步小视频数据! 当前时间：{}", new Date());
        videoSyncService.sync();
        log.info("结束同步小视频数据! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncVideoTask";
    }

    @Override
    public String cron() {
        return "0 10/20 * * * ?";
    }

    @Override
    public String description() {
        return "小视频同步任务";
    }

}
