package com.bxm.localnews.task;

import com.bxm.localnews.service.WechatNewsSyncService;
import com.bxm.newidea.component.schedule.task.AbstractCronTask;
import com.xxl.job.core.biz.model.ReturnT;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 创建即发布的周期定时任务
 */
@Component
@Slf4j
public class SyncWechatNewsTask extends AbstractCronTask<String> {

    @Resource
    private WechatNewsSyncService wechatNewsSyncService;

    @Override
    protected ReturnT<String> service(String param) {
        log.info("开始同步微信公众号新闻数据! 当前时间：{}", new Date());
        wechatNewsSyncService.sync();
        log.info("结束同步微信公众号新闻数据! 当前时间：{}", new Date());
        return ReturnT.SUCCESS;
    }

    @Override
    public String taskName() {
        return "syncWechatNewsTask";
    }

    @Override
    public String cron() {
        return "0 25/20 * * * ?";
    }

    @Override
    public String description() {
        return "微信公众号新闻同步任务";
    }

}
