package com.bxm.localnews.thread;


import com.bxm.localnews.service.NewsSyncService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.CountDownLatch;


/**
 * 新闻同步线程，新闻有10个分表需要进行同步
 */
public class NewsSyncThread implements Runnable {

    private static final Logger logger = LoggerFactory.getLogger(NewsSyncThread.class);

    private NewsSyncService newsSyncService;

    private CountDownLatch countDownLatch;

    private Integer offset;

    public NewsSyncThread build(Integer offset, CountDownLatch countDownLatch) {
        this.newsSyncService = SpringContextHolder.getApplicationContext().getBean(NewsSyncService.class);
        this.countDownLatch = countDownLatch;
        this.offset = offset;
        return this;
    }

    @Override
    public void run() {
        logger.debug("news thread:" + Thread.currentThread().getId() + "begin work");
        try {
            this.newsSyncService.sync(this.offset);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            this.countDownLatch.countDown();
        }
        logger.debug("news thread:" + Thread.currentThread().getId() + "end work");
    }
}
