package com.bxm.localnews.thread;

import com.bxm.localnews.service.UserStatisticService;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.concurrent.CountDownLatch;

/**
 * 用户静态数据计算
 */
public class UserStatisticSyncThread implements Runnable {

    private static final Logger logger = LoggerFactory.getLogger(UserStatisticSyncThread.class);

    private UserStatisticService userStatisticService;

    private CountDownLatch countDownLatch;

    private Integer offset;

    private List<Long> idList;

    public UserStatisticSyncThread build(Integer offset, List<Long> idList, CountDownLatch countDownLatch) {
        this.userStatisticService = SpringContextHolder.getApplicationContext().getBean(UserStatisticService.class);
        this.countDownLatch = countDownLatch;
        this.idList = idList;
        this.offset = offset;
        return this;
    }

    @Override
    public void run() {
        logger.debug("user statistic thread:" + Thread.currentThread().getId() + "begin work");
        try {
            this.userStatisticService.sync(idList,this.offset);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
        } finally {
            this.countDownLatch.countDown();
        }
        logger.debug("user statistic thread:" + Thread.currentThread().getId() + "end work");
    }
}
