/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.analysis.TFIDFAnalyzesService;
import com.bxm.localnews.channel.DataChannelService;
import com.bxm.localnews.convert.impl.NewsConverter;
import com.bxm.localnews.service.CommonTagService;
import com.bxm.localnews.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.sync.primary.dao.HotnewsAgingMapper;
import com.bxm.localnews.sync.primary.dao.HotnewsAgingRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingTagMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsReplyMapper;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.primary.dao.NewsTagMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.local.HotnewsAging;
import com.bxm.localnews.sync.vo.local.LocalnewsAging;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsAging;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsTag;
import com.bxm.newidea.component.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;

abstract class AbstractNewsDataChannelServiceImpl<T>
implements DataChannelService<T> {
    @Autowired
    @Qualifier(value="primarySessionTemplate")
    protected SqlSessionTemplate primarySessionTemplate;
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected LocalnewsPersistentMapper localnewsPersistentMapper;
    @Autowired
    protected LocalnewsAgingMapper localnewsAgingMapper;
    @Autowired
    protected HotnewsAgingMapper hotnewsAgingMapper;
    @Autowired
    protected NewsRecommendedMapper newsRecommendedMapper;
    @Autowired
    protected NewsAgingRecommendedMapper newsAgingRecommendedMapper;
    @Autowired
    protected NewsPersistentRecommendedMapper newsPersistentRecommendedMapper;
    @Autowired
    protected HotnewsAgingRecommendedMapper hotnewsAgingRecommendedMapper;
    @Autowired
    protected LocalnewsPersistentRecommendedMapper localnewsPersistentRecommendedMapper;
    @Autowired
    protected LocalnewsAgingRecommendedMapper localnewsAgingRecommendedMapper;
    @Autowired
    protected NewsReplyMapper newsReplyMapper;
    @Autowired
    protected UserReplyMapper userReplyMapper;
    @Autowired
    NewsStatisticsMapper newsStatisticsMapper;
    @Autowired
    NewsMapper newsMapper;
    @Autowired
    NewsTagMapper newsTagMapper;
    @Autowired
    CommonTagService commonTagService;
    @Autowired
    TFIDFAnalyzesService tfidfAnalyzesService;
    @Autowired
    NewsConverter newsConverter;
    @Autowired
    NewsAgingTagMapper newsAgingTagMapper;
    @Autowired
    NewsAgingMapper newsAgingMapper;
    @Autowired
    NewsPersistentMapper newsPersistentMapper;
    @Autowired
    private NewsPersistentTagMapper newsPersistentTagMapper;
    @Autowired
    private LocalnewsPersistentTagMapper localnewsPersistentTagMapper;
    @Autowired
    private LocalnewsAgingTagMapper localnewsAgingTagMapper;

    AbstractNewsDataChannelServiceImpl() {
    }

    @Override
    void remove(News news) {
        this.clearNewsAging(news);
        this.newsMapper.updateStatusById(news.getId(), news.getStatus());
    }

    private void cleanNewsTotal(Long newsId) {
        this.newsMapper.deleteById(newsId);
        this.newsTagMapper.deleteByNewsId(newsId);
        this.newsRecommendedMapper.deleteByNewsId(newsId);
    }

    void clearDirtyData(News data) {
        this.clearNewsAging(data);
        this.cleanNewsTotal(data.getId());
    }

    void clearModifyDirtyData(News data) {
        this.clearNewsAging(data);
        this.newsTagMapper.deleteByNewsId(data.getId());
    }

    void clearNewsAging(News data) {
        News oldNews = this.newsMapper.selectByPrimaryKey(data.getId());
        if (null != oldNews) {
            this.newsAgingMapper.deleteById(data.getId());
            this.newsPersistentMapper.deleteById(data.getId());
            this.newsAgingTagMapper.deleteByNewsId(data.getId());
            this.newsPersistentTagMapper.deleteByNewsId(data.getId());
            this.newsAgingRecommendedMapper.deleteByNewsId(data.getId());
            this.newsPersistentRecommendedMapper.deleteByNewsId(data.getId());
            if (StringUtils.isNotEmpty((CharSequence)oldNews.getAreaDetail())) {
                String[] areaCodeList;
                for (String areaCode : areaCodeList = oldNews.getAreaDetail().split(",")) {
                    Long province = Long.valueOf(areaCode.substring(0, 2));
                    LocalnewsAging localnewsAging = new LocalnewsAging();
                    localnewsAging.setProvince(province);
                    localnewsAging.setId(data.getId());
                    this.localnewsPersistentMapper.deleteByModel(localnewsAging);
                    this.localnewsAgingMapper.deleteByModel(localnewsAging);
                    NewsTag newsTag = new NewsTag();
                    newsTag.setProvince(province);
                    newsTag.setNewsId(data.getId());
                    this.localnewsPersistentTagMapper.deleteByModel(newsTag);
                    this.localnewsAgingTagMapper.deleteByModel(newsTag);
                    NewsRecommended newsRecommended = new NewsRecommended();
                    newsRecommended.setProvince(province);
                    newsRecommended.setNewsId(data.getId());
                    this.localnewsPersistentRecommendedMapper.deleteByModel(newsRecommended);
                    this.localnewsAgingRecommendedMapper.deleteByModel(newsRecommended);
                }
            }
            this.hotnewsAgingMapper.deleteById(data.getId());
            this.hotnewsAgingRecommendedMapper.deleteByNewsId(data.getId());
        }
    }

    boolean modifyNews(News news) {
        News oldNews = this.newsMapper.selectByPrimaryKey(news.getId());
        if (oldNews != null) {
            this.clearModifyDirtyData(oldNews);
            this.updateNews(news, oldNews);
            this.logger.debug("\u6570\u636e\u53d8\u66f4:{}", (Object)news.getId());
            return true;
        }
        return false;
    }

    private List<NewsTag> saveNewsTag(News news) {
        List<NewsTag> newsTagList = this.listNewsTag(news);
        MybatisBatchBuilder.create(NewsTagMapper.class, newsTagList).sessionTemplate(this.primarySessionTemplate).run(NewsTagMapper::save);
        return newsTagList;
    }

    private List<NewsTag> listNewsTag(News news) {
        ArrayList<NewsTag> newsTagList = new ArrayList<NewsTag>();
        if (StringUtils.isNotBlank((CharSequence)news.getKindName())) {
            Keyword keyword = new Keyword();
            keyword.setName(news.getKindName());
            this.generateTag(newsTagList, keyword, NewsTagTypeEnum.TITLE_TAG.getCode(), news.getId());
        }
        if (news.getKeywordList() != null) {
            for (Keyword keyword : news.getKeywordList()) {
                this.generateTag(newsTagList, keyword, NewsTagTypeEnum.CHANNEL_TAG.getCode(), news.getId());
            }
        }
        return newsTagList;
    }

    private void generateTag(List<NewsTag> newsTagList, Keyword keyword, Byte type, Long newsId) {
        NewsTag newsTag = new NewsTag();
        newsTag.setAddTime(Calendar.getInstance().getTime());
        newsTag.setName(keyword.getName());
        newsTag.setTagType(type);
        newsTag.setNewsId(newsId);
        if (type.equals(NewsTagTypeEnum.TITLE_TAG.getCode())) {
            newsTag.setWeight(Double.valueOf(0.0));
        } else {
            newsTag.setWeight(Double.valueOf(keyword.getTfidfvalue()));
        }
        newsTag.setTagId(Long.valueOf(this.commonTagService.saveAndGetTag(keyword.getName())));
        newsTagList.add(newsTag);
    }

    void saveNews(News data) {
        List<NewsTag> newsTagList = this.saveNewsTag(data);
        this.newsMapper.save(data);
        if (!CollectionUtils.isEmpty((Collection)data.getNewsReplyList())) {
            List newsReplyList = data.getNewsReplyList();
            MybatisBatchBuilder.create(NewsReplyMapper.class, (Collection)newsReplyList).sessionTemplate(this.primarySessionTemplate).run(NewsReplyMapper::insertSelective);
            MybatisBatchBuilder.create(UserReplyMapper.class, (Collection)newsReplyList).sessionTemplate(this.primarySessionTemplate).run(UserReplyMapper::insertSelective);
            long count = newsReplyList.stream().map(e -> e.getParentId() == 0L).count();
            if (count > 0L) {
                this.newsReplyMapper.updateNewsComments(data.getId(), Integer.valueOf((int)count));
            }
        }
        if (2 != data.getReviewStatus() || 1 != data.getStatus()) {
            return;
        }
        if (data.getTop() == 2 || data.getKindTop() == 2) {
            return;
        }
        if (data.getHot() == 2) {
            this.putNewsToHotRecommendPool(data, new ArrayList<NewsRecommended>());
            return;
        }
        if (null != data.getAreaDetail() && data.getDeliveryType() == 1) {
            this.putNewsToLocalRecommendPool(data, newsTagList, new ArrayList<NewsRecommended>());
            return;
        }
        this.putNewsToNationalRecommendPool(data, newsTagList, new ArrayList<NewsRecommended>());
    }

    void updateNews(News data, News oldNews) {
        List<NewsTag> newsTagList = this.saveNewsTag(data);
        List newsRecommendedList = this.newsRecommendedMapper.selectByNewsId(data.getId());
        data.setModifyTime(new Date());
        this.newsMapper.updateByPrimaryKeySelective(data);
        data.setShares(oldNews.getShares());
        data.setViews(oldNews.getViews());
        data.setRecommends(oldNews.getRecommends());
        data.setComments(oldNews.getComments());
        data.setActiveViews(oldNews.getActiveViews());
        data.setNewClicks(oldNews.getNewClicks());
        if (2 != data.getReviewStatus() || 1 != data.getStatus()) {
            return;
        }
        if (data.getTop() == 2 || data.getKindTop() == 2) {
            return;
        }
        if (data.getHot() == 2) {
            this.putNewsToHotRecommendPool(data, newsRecommendedList);
            return;
        }
        if (null != data.getAreaDetail() && data.getDeliveryType() == 1) {
            this.putNewsToLocalRecommendPool(data, newsTagList, newsRecommendedList);
            return;
        }
        this.putNewsToNationalRecommendPool(data, newsTagList, newsRecommendedList);
    }

    void putNewsToHotRecommendPool(News data, List<NewsRecommended> newsRecommendedList) {
        if (StringUtils.isNotEmpty((CharSequence)data.getAreaDetail())) {
            List<String> areaCodeList = Arrays.asList(data.getAreaDetail().split(","));
            for (String areaCode : areaCodeList) {
                HotnewsAging hotnewsAging = new HotnewsAging();
                BeanUtils.copyProperties((Object)data, (Object)hotnewsAging);
                hotnewsAging.setId(data.getId());
                hotnewsAging.setAreaCode(areaCode);
                hotnewsAging.setType(Byte.valueOf((byte)1));
                this.hotnewsAgingMapper.save(hotnewsAging);
            }
        } else {
            HotnewsAging hotnewsAging = new HotnewsAging();
            BeanUtils.copyProperties((Object)data, (Object)hotnewsAging);
            hotnewsAging.setId(data.getId());
            hotnewsAging.setAreaCode(null);
            hotnewsAging.setType(Byte.valueOf((byte)1));
            this.hotnewsAgingMapper.save(hotnewsAging);
        }
        for (NewsRecommended newsRecommended : newsRecommendedList) {
            this.hotnewsAgingRecommendedMapper.insert(newsRecommended);
        }
    }

    void putNewsToLocalRecommendPool(News data, List<NewsTag> newsTagList, List<NewsRecommended> newsRecommendedList) {
        Date issueTime = data.getIssueTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, -240);
        Date agingTime = calendar.getTime();
        List<String> areaCodeList = Arrays.asList(data.getAreaDetail().split(","));
        for (String areaCode : areaCodeList) {
            Long province = Long.valueOf(areaCode.substring(0, 2));
            LocalnewsAging localnewsAging = new LocalnewsAging();
            BeanUtils.copyProperties((Object)data, (Object)localnewsAging);
            localnewsAging.setAreaCode(areaCode);
            localnewsAging.setProvince(province);
            localnewsAging.setId(data.getId());
            this.localnewsPersistentMapper.save(localnewsAging);
            if (issueTime.compareTo(agingTime) > 0) {
                this.localnewsAgingMapper.save(localnewsAging);
            }
            newsTagList = newsTagList.stream().map(e -> e.setProvince(province)).collect(Collectors.toList());
            newsRecommendedList = newsRecommendedList.stream().map(e -> e.setProvince(province)).collect(Collectors.toList());
            MybatisBatchBuilder.create(LocalnewsPersistentTagMapper.class, newsTagList).sessionTemplate(this.primarySessionTemplate).run(LocalnewsPersistentTagMapper::save);
            if (issueTime.compareTo(agingTime) > 0) {
                MybatisBatchBuilder.create(LocalnewsAgingTagMapper.class, newsTagList).sessionTemplate(this.primarySessionTemplate).run(LocalnewsAgingTagMapper::save);
            }
            MybatisBatchBuilder.create(LocalnewsPersistentRecommendedMapper.class, newsRecommendedList).sessionTemplate(this.primarySessionTemplate).run(LocalnewsPersistentRecommendedMapper::insert);
            if (issueTime.compareTo(agingTime) <= 0) continue;
            MybatisBatchBuilder.create(LocalnewsAgingRecommendedMapper.class, newsRecommendedList).sessionTemplate(this.primarySessionTemplate).run(LocalnewsAgingRecommendedMapper::insert);
        }
    }

    void putNewsToNationalRecommendPool(News data, List<NewsTag> newsTagList, List<NewsRecommended> newsRecommendedList) {
        Date issueTime = data.getIssueTime();
        Calendar calendar = Calendar.getInstance();
        calendar.add(10, -240);
        Date agingTime = calendar.getTime();
        NewsAging newsAging = new NewsAging();
        newsAging.setActiveViews(data.getActiveViews()).setId(data.getId()).setComments(data.getComments()).setNewClicks(data.getNewClicks()).setRecommends(data.getRecommends()).setShares(data.getShares()).setCollects(data.getCollects()).setViews(data.getViews()).setIssueTime(data.getIssueTime()).setKindId(data.getKindId());
        this.newsPersistentMapper.save(newsAging);
        if (issueTime.compareTo(agingTime) > 0) {
            this.newsAgingMapper.save(newsAging);
        }
        MybatisBatchBuilder.create(NewsPersistentTagMapper.class, newsTagList).sessionTemplate(this.primarySessionTemplate).run(NewsPersistentTagMapper::save);
        if (issueTime.compareTo(agingTime) > 0) {
            MybatisBatchBuilder.create(NewsAgingTagMapper.class, newsTagList).sessionTemplate(this.primarySessionTemplate).run(NewsAgingTagMapper::save);
        }
        MybatisBatchBuilder.create(NewsPersistentRecommendedMapper.class, newsRecommendedList).sessionTemplate(this.primarySessionTemplate).run(NewsPersistentRecommendedMapper::insert);
        if (issueTime.compareTo(agingTime) > 0) {
            MybatisBatchBuilder.create(NewsAgingRecommendedMapper.class, newsRecommendedList).sessionTemplate(this.primarySessionTemplate).run(NewsAgingRecommendedMapper::insert);
        }
    }
}

