/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.impl.AbstractNewsDataChannelServiceImpl;
import com.bxm.localnews.convert.impl.AdminNewsEntryConverter;
import com.bxm.localnews.convert.impl.AdminNewsUpdateConverter;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.vo.local.AdminNews;
import com.bxm.localnews.sync.vo.local.News;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class AdminNewsDataChannelServiceImpl
extends AbstractNewsDataChannelServiceImpl<AdminNews> {
    private final AdminNewsEntryConverter adminNewsEntryConverter;
    private final AdminNewsUpdateConverter adminNewsUpdateConverter;

    @Autowired(required=false)
    public AdminNewsDataChannelServiceImpl(AdminNewsUpdateConverter adminNewsUpdateConverter, NewsStatisticsMapper newsStatisticsMapper, AdminNewsEntryConverter adminNewsEntryConverter) {
        this.adminNewsEntryConverter = adminNewsEntryConverter;
        this.adminNewsUpdateConverter = adminNewsUpdateConverter;
        this.newsStatisticsMapper = newsStatisticsMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(AdminNews data) {
        this.logger.debug("\u7ba1\u7406\u540e\u53f0\u64cd\u4f5c\u6570\u636e\u65b0\u589e:{}", (Object)data.getId());
        News localNews = this.adminNewsEntryConverter.convert(data);
        this.saveNews(localNews);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clear(AdminNews data) {
        News news = new News();
        news.setId(data.getId());
        news.setStatus(data.getStatus());
        this.clearDirtyData(news);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(AdminNews data) {
        News news = new News();
        news.setAreaDetail(data.getAreaDetail());
        news.setId(data.getId());
        news.setStatus(data.getStatus());
        this.remove(news);
    }

    @Override
    public boolean modify(AdminNews data) {
        return this.modifyNews(this.adminNewsUpdateConverter.convert(data));
    }

    @Override
    public Class<AdminNews> supports() {
        return AdminNews.class;
    }
}

