/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.DataChannelService;
import com.bxm.localnews.convert.impl.CouponConverter;
import com.bxm.localnews.sync.third.dao.CouponMapper;
import com.bxm.localnews.sync.vo.local.Coupon;
import com.bxm.localnews.sync.vo.spider.SpiderCouponGoods;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CouponServiceImpl
implements DataChannelService<SpiderCouponGoods> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CouponServiceImpl.class);
    @Autowired
    private CouponMapper couponMapper;
    @Autowired
    private CouponConverter couponConverter;

    @Override
    public void save(SpiderCouponGoods data) {
        Coupon coupon = this.couponConverter.convert(data);
        this.couponMapper.insert(coupon);
    }

    @Override
    public void remove(SpiderCouponGoods data) {
        this.couponMapper.deleteByPrimaryKey(data.getId());
    }

    @Override
    public boolean modify(SpiderCouponGoods data) {
        if (this.couponMapper.exists(data.getId()) != 0) {
            this.remove(data);
            this.save(data);
            LOGGER.debug("\u4f18\u60e0\u5238\uff1a{}\u88ab\u53d8\u66f4\uff0c\u8fdb\u884c\u6570\u636e\u66f4\u65b0", (Object)data.getId());
            return true;
        }
        return false;
    }

    @Override
    public Class<SpiderCouponGoods> supports() {
        return SpiderCouponGoods.class;
    }
}

