/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.channel.DataChannelService;
import com.bxm.localnews.convert.impl.ForumPostConverter;
import com.bxm.localnews.sync.primary.dao.ForumPostMapper;
import com.bxm.localnews.sync.primary.dao.NewsReplyMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.vo.local.ForumPost;
import com.bxm.localnews.sync.vo.spider.SpiderForumPost;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class ForumPostChannelServiceImpl
implements DataChannelService<SpiderForumPost> {
    private final ForumPostConverter forumPostConverter;
    private final ForumPostMapper forumPostMapper;

    @Autowired
    public ForumPostChannelServiceImpl(ForumPostConverter forumPostConverter, ForumPostMapper forumPostMapper) {
        this.forumPostConverter = forumPostConverter;
        this.forumPostMapper = forumPostMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SpiderForumPost data) {
        ForumPost forumPost = this.forumPostConverter.convert(data);
        this.forumPostMapper.savePost(forumPost);
        if (!CollectionUtils.isEmpty((Collection)forumPost.getReplyList())) {
            MybatisBatchBuilder.create(NewsReplyMapper.class, (Collection)forumPost.getReplyList()).sessionTemplateName("primarySessionTemplate").run(NewsReplyMapper::insertSelective);
            MybatisBatchBuilder.create(UserReplyMapper.class, (Collection)forumPost.getReplyList()).sessionTemplateName("primarySessionTemplate").run(UserReplyMapper::insertSelective);
        }
        if (null != forumPost.getForumPostTopic()) {
            this.forumPostMapper.savePostTopic(forumPost.getForumPostTopic());
        }
    }

    @Override
    public void remove(SpiderForumPost data) {
    }

    @Override
    public boolean modify(SpiderForumPost data) {
        return false;
    }

    @Override
    public void clear(SpiderForumPost data) {
    }

    @Override
    public Class<SpiderForumPost> supports() {
        return SpiderForumPost.class;
    }
}

