/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.impl.AbstractNewsDataChannelServiceImpl;
import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.primary.dao.NewsStatisticsMapper;
import com.bxm.localnews.sync.primary.dao.NewsTagMapper;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NewsStatisticDataChannelServiceImpl
extends AbstractNewsDataChannelServiceImpl<NewsStatistics> {
    private final NewsMapper newsMapper;

    @Autowired(required=false)
    public NewsStatisticDataChannelServiceImpl(NewsMapper newsMapper, NewsStatisticsMapper newsStatisticsMapper, NewsTagMapper newsTagMapper) {
        this.newsMapper = newsMapper;
        this.newsStatisticsMapper = newsStatisticsMapper;
        this.newsTagMapper = newsTagMapper;
    }

    @Override
    public void save(NewsStatistics data) {
    }

    @Override
    public void clear(NewsStatistics data) {
    }

    @Override
    public void remove(NewsStatistics data) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean modify(NewsStatistics data) {
        return this.modifyNewsStatistics(data);
    }

    @Override
    public Class<NewsStatistics> supports() {
        return NewsStatistics.class;
    }

    private boolean modifyNewsStatistics(NewsStatistics data) {
        News news = this.newsMapper.selectByPrimaryKey(data.getNewsId());
        if (news != null) {
            this.updateNews(data, news);
            this.logger.debug("\u65b0\u95fb\u9759\u6001\u6570\u636e\u53d8\u66f4:{}", (Object)news.getId());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNews(NewsStatistics data, News news) {
        SqlSessionTemplate primarySessionTemplate = (SqlSessionTemplate)SpringContextHolder.getBean((String)"primarySessionTemplate");
        SqlSession session = primarySessionTemplate.getSqlSessionFactory().openSession(ExecutorType.BATCH);
        try {
            if (data.getComments() == null || data.getComments() == 0) {
                this.newsMapper.updateStatisticByPrimaryKeySelective(data);
            }
            if (2 != news.getReviewStatus() || 1 != news.getStatus()) {
                return;
            }
            if (news.getTop() == 2 || news.getKindTop() == 2) {
                return;
            }
            if (news.getHot() == 2) {
                this.putNewsToHotRecommendPool(data);
                return;
            }
            if (null != news.getAreaDetail()) {
                this.putNewsToLocalRecommendPool(data, news.getAreaDetail());
                return;
            }
            this.putNewsToNationalRecommendPool(data);
        }
        catch (Exception e) {
            session.rollback();
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            session.commit();
            session.clearCache();
            session.close();
        }
    }

    private void putNewsToHotRecommendPool(NewsStatistics data) {
        this.hotnewsAgingMapper.updateStatisticByPrimaryKeySelective(data);
    }

    private void putNewsToLocalRecommendPool(NewsStatistics data, String areaDetail) {
        String[] areaCodeList;
        for (String areaCode : areaCodeList = areaDetail.split(",")) {
            Long province = Long.valueOf(areaCode.substring(0, 2));
            data.setProvince(province);
            this.localnewsAgingMapper.updateStatisticByPrimaryKeySelective(data);
            this.localnewsPersistentMapper.updateStatisticByPrimaryKeySelective(data);
        }
    }

    private void putNewsToNationalRecommendPool(NewsStatistics data) {
        this.newsAgingMapper.updateStatisticByPrimaryKeySelective(data);
        this.newsPersistentMapper.updateStatisticByPrimaryKeySelective(data);
    }
}

