/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.impl.AbstractNewsDataChannelServiceImpl;
import com.bxm.localnews.convert.impl.NewsStatusConverter;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsStatus;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsStatusDataChannelServiceImpl
extends AbstractNewsDataChannelServiceImpl<NewsStatus> {
    private final NewsStatusConverter newsStatusConverter;

    @Autowired(required=false)
    public NewsStatusDataChannelServiceImpl(NewsStatusConverter newsStatusConverter) {
        this.newsStatusConverter = newsStatusConverter;
    }

    @Override
    public void save(NewsStatus data) {
    }

    @Override
    public void clear(NewsStatus data) {
    }

    @Override
    public void remove(NewsStatus data) {
    }

    @Override
    public boolean modify(NewsStatus data) {
        return this.modifyNews(this.newsStatusConverter.convert(data));
    }

    @Override
    public Class<NewsStatus> supports() {
        return NewsStatus.class;
    }

    @Override
    boolean modifyNews(News news) {
        News oldNews = this.newsMapper.selectByPrimaryKey(news.getId());
        if (oldNews != null) {
            this.clearNewsAging(oldNews);
            this.updateNewsStatus(news, oldNews);
            this.logger.debug("\u7ba1\u7406\u540e\u53f0\u64cd\u4f5c\u6570\u636e(\u72b6\u6001)\u53d8\u66f4:{}", (Object)news.getId());
            return true;
        }
        return false;
    }

    private void updateNewsStatus(News data, News oldNews) {
        List newsTagList = this.newsTagMapper.selectByNewsId(data.getId());
        List newsRecommendedList = this.newsRecommendedMapper.selectByNewsId(data.getId());
        this.newsMapper.updateStatusByPrimaryKeySelective(data);
        if (null != data.getStatus()) {
            oldNews.setStatus(data.getStatus());
        }
        if (null != data.getReviewStatus()) {
            oldNews.setReviewStatus(data.getReviewStatus());
        }
        if (null != data.getHot()) {
            oldNews.setHot(data.getHot());
        }
        if (2 != oldNews.getReviewStatus() || 1 != oldNews.getStatus()) {
            return;
        }
        if (oldNews.getTop() == 2 || oldNews.getKindTop() == 2) {
            return;
        }
        if (oldNews.getHot() == 2) {
            this.putNewsToHotRecommendPool(oldNews, newsRecommendedList);
            return;
        }
        if (null != oldNews.getAreaDetail()) {
            this.putNewsToLocalRecommendPool(oldNews, newsTagList, newsRecommendedList);
            return;
        }
        this.putNewsToNationalRecommendPool(oldNews, newsTagList, newsRecommendedList);
    }
}

