/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.channel.DataChannelService;
import com.bxm.localnews.convert.impl.VideoConverter;
import com.bxm.localnews.service.CommonTagService;
import com.bxm.localnews.sync.enums.NewsTagTypeEnum;
import com.bxm.localnews.sync.primary.dao.NewsReplyMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.primary.dao.VideoMapper;
import com.bxm.localnews.sync.primary.dao.VideoTagMapper;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.local.LocalVideo;
import com.bxm.localnews.sync.vo.local.VideoTag;
import com.bxm.localnews.sync.vo.spider.SpiderVideo;
import java.util.Calendar;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class VideoChannelServiceImpl
implements DataChannelService<SpiderVideo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoChannelServiceImpl.class);
    private final VideoConverter videoConverter;
    private final VideoMapper videoMapper;
    private VideoTagMapper videoTagMapper;
    private CommonTagService commonTagService;
    private UserReplyMapper userReplyMapper;
    private NewsReplyMapper newsReplyMapper;

    @Autowired
    public VideoChannelServiceImpl(VideoMapper videoMapper, VideoConverter videoConverter, VideoTagMapper videoTagMapper, CommonTagService commonTagService, UserReplyMapper userReplyMapper, NewsReplyMapper newsReplyMapper) {
        this.videoMapper = videoMapper;
        this.videoConverter = videoConverter;
        this.videoTagMapper = videoTagMapper;
        this.commonTagService = commonTagService;
        this.userReplyMapper = userReplyMapper;
        this.newsReplyMapper = newsReplyMapper;
    }

    @Override
    public void save(SpiderVideo data) {
        LocalVideo localVideo = this.videoConverter.convert(data);
        this.videoMapper.save(localVideo);
        if (!CollectionUtils.isEmpty((Collection)localVideo.getNewsReplyList())) {
            String primarySessionTemplate = "primarySessionTemplate";
            MybatisBatchBuilder.create(NewsReplyMapper.class, (Collection)localVideo.getNewsReplyList()).sessionTemplateName(primarySessionTemplate).run(NewsReplyMapper::insertSelective);
            MybatisBatchBuilder.create(UserReplyMapper.class, (Collection)localVideo.getNewsReplyList()).sessionTemplateName(primarySessionTemplate).run(UserReplyMapper::insertSelective);
        }
        if (!CollectionUtils.isEmpty((Collection)localVideo.getKeywordList())) {
            for (Keyword keyword : localVideo.getKeywordList()) {
                VideoTag videoTag = new VideoTag();
                videoTag.setAddTime(Calendar.getInstance().getTime());
                videoTag.setName(keyword.getName());
                videoTag.setTagType(NewsTagTypeEnum.TITLE_TAG.getCode());
                videoTag.setWeight(Double.valueOf(keyword.getTfidfvalue()));
                videoTag.setVideoId(localVideo.getId());
                videoTag.setTagId(Long.valueOf(this.commonTagService.saveAndGetTag(keyword.getName())));
                this.videoTagMapper.insert(videoTag);
            }
        }
    }

    @Override
    public void remove(SpiderVideo data) {
        this.videoMapper.deleteById(data.getId());
        this.videoTagMapper.removeByVideoId(data.getId());
        this.newsReplyMapper.deleteNewsReplyByNewsIdAndType(data.getId(), Integer.valueOf(2));
        this.userReplyMapper.deleteUserReplyByNewsIdAndType(data.getId(), Integer.valueOf(2), Long.valueOf(0L));
    }

    @Override
    public boolean modify(SpiderVideo data) {
        if (this.videoMapper.exists(data.getId()) != 0) {
            this.remove(data);
            this.save(data);
            LOGGER.debug("\u89c6\u9891\uff1a{}\u88ab\u53d8\u66f4\uff0c\u8fdb\u884c\u6570\u636e\u66f4\u65b0", (Object)data.getId());
            return true;
        }
        return false;
    }

    @Override
    public Class<SpiderVideo> supports() {
        return SpiderVideo.class;
    }
}

