/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.channel.impl;

import com.bxm.localnews.channel.impl.AbstractNewsDataChannelServiceImpl;
import com.bxm.localnews.convert.impl.WechatNewsConverter;
import com.bxm.localnews.sync.primary.dao.NewsMapper;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class WechatNewsChannelServiceImpl
extends AbstractNewsDataChannelServiceImpl<SpiderWechatNews> {
    private final WechatNewsConverter wechatNewsConverter;
    private final NewsMapper newsMapper;

    @Autowired(required=false)
    public WechatNewsChannelServiceImpl(WechatNewsConverter wechatNewsConverter, NewsMapper newsMapper) {
        this.wechatNewsConverter = wechatNewsConverter;
        this.newsMapper = newsMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(SpiderWechatNews data) {
        News localNews = this.wechatNewsConverter.convert(data);
        this.saveNews(localNews);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(SpiderWechatNews data) {
        this.newsMapper.updateStatusById(data.getId(), data.getStatus());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean modify(SpiderWechatNews data) {
        return this.modifyNews(this.wechatNewsConverter.convert(data));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void clear(SpiderWechatNews data) {
        News news = new News();
        news.setAreaDetail(data.getRegion());
        news.setId(data.getId());
        news.setStatus(data.getStatus());
        this.clearDirtyData(news);
    }

    @Override
    public Class<SpiderWechatNews> supports() {
        return SpiderWechatNews.class;
    }
}

