/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.convert.impl;

import com.bxm.localnews.convert.Converter;
import com.bxm.localnews.convert.impl.NewsReplyConverter;
import com.bxm.localnews.sync.primary.dao.NewsKindMapper;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsImg;
import com.bxm.localnews.sync.vo.local.NewsKind;
import com.bxm.localnews.sync.vo.local.NewsReply;
import com.bxm.localnews.sync.vo.spider.NewsComment;
import com.bxm.newidea.component.tools.RandomUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.util.CollectionUtils;

abstract class AbstractConverter<T, K>
implements Converter<T, K> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private NewsKindMapper newsKindMapper;
    private ObjectMapper objectMapper = new ObjectMapper();

    AbstractConverter() {
    }

    Integer getKindId(String kindName) {
        Optional<NewsKind> kind = this.getKinds().stream().filter(newsKind -> newsKind.getName().equals(kindName.trim())).findFirst();
        return kind.isPresent() ? kind.get().getId() : 0;
    }

    boolean hasKindId(int kindId) {
        return this.getKinds().stream().anyMatch(kind -> kind.getId() == kindId);
    }

    public NewsKind getKind(int kindId) {
        return this.getKinds().stream().filter(kind -> kindId == kind.getId()).findFirst().orElse(new NewsKind());
    }

    @Cacheable(value={"getKinds"}, sync=true)
    public List<NewsKind> getKinds() {
        return this.newsKindMapper.selectAllKinds();
    }

    String toJsonString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            this.logger.error(obj + "\u89e3\u6790\u51fa\u9519", (Throwable)e);
            return "";
        }
    }

    protected void generateNewsStatistic(News news) {
        news.setClicks(Integer.valueOf(RandomUtils.nextInt((int)2000, (int)6000)));
        news.setViews(Integer.valueOf(RandomUtils.nextInt((int)2000, (int)6000)));
        news.setCollects(Integer.valueOf(0));
        news.setComments(Integer.valueOf(0));
        news.setRecommends(Integer.valueOf(100));
        news.setActiveViews(Integer.valueOf(RandomUtils.nextInt((int)2000, (int)6000)));
        news.setShares(Integer.valueOf(0));
        news.setNewClicks(Integer.valueOf(RandomUtils.nextInt((int)2000, (int)6000)));
    }

    protected String extractVideo(String content, List<NewsImg> postImgList) {
        Document document = Jsoup.parse((String)content);
        document.outputSettings().prettyPrint(true).indentAmount(1);
        Elements elements = document.select("video");
        if (null != elements) {
            for (Element element : elements) {
                NewsImg img = new NewsImg();
                img.setType("VIDEO");
                String src = element.attr("src");
                if (StringUtils.isBlank((String)src)) continue;
                img.setVideoUrl(src);
                String poster = element.attr("poster");
                if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)poster)) {
                    img.setImgUrl(poster);
                }
                postImgList.add(img);
            }
        }
        return document.body().html().replace("\n", "");
    }

    protected List<NewsReply> convertNewsCommentToNewReply(List<NewsComment> commentList) {
        ArrayList<NewsReply> resultList = new ArrayList<NewsReply>();
        if (CollectionUtils.isEmpty(commentList)) {
            return resultList;
        }
        List<NewsComment> oneLevelList = commentList.stream().filter(e -> Objects.isNull(e.getParentId())).collect(Collectors.toList());
        NewsReplyConverter replyConverter = new NewsReplyConverter();
        oneLevelList.forEach(e -> replyConverter.judgeNewsReplyLevel((List<NewsReply>)resultList, (NewsComment)e));
        return resultList;
    }
}

