/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.convert.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.convert.Converter;
import com.bxm.localnews.sync.third.dao.UserMapper;
import com.bxm.localnews.sync.vo.business.PostImg;
import com.bxm.localnews.sync.vo.business.User;
import com.bxm.localnews.sync.vo.local.ForumPost;
import com.bxm.localnews.sync.vo.local.ForumPostTopic;
import com.bxm.localnews.sync.vo.local.NewsReply;
import com.bxm.localnews.sync.vo.spider.SpiderForumPost;
import com.bxm.localnews.sync.vo.spider.SpiderForumPostComment;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.HtmlContentUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ForumPostConverter
extends BaseService
implements Converter<SpiderForumPost, ForumPost> {
    private final RedisStringAdapter redisStringAdapter;
    private final UserMapper userMapper;

    public ForumPostConverter(RedisStringAdapter redisStringAdapter, UserMapper userMapper) {
        this.redisStringAdapter = redisStringAdapter;
        this.userMapper = userMapper;
    }

    @Override
    public ForumPost convert(SpiderForumPost data) {
        ForumPost forumPost = new ForumPost();
        forumPost.setId(this.getPostId());
        forumPost.setTitle(data.getTitle());
        forumPost.setContent(data.getContent());
        forumPost.setTextField(HtmlContentUtils.delHtmlTags((String)data.getContent()));
        forumPost.setImgList(this.parseImageList(data.getContent()));
        forumPost.setCreateTime(new Date());
        forumPost.setUserId(data.getUserId());
        User user = this.userMapper.selectUserById(forumPost.getUserId());
        if (null != user) {
            forumPost.setUserImg(user.getHeadImg());
            forumPost.setUserName(user.getNickname());
        }
        forumPost.setAreaCode(data.getAreaCode());
        forumPost.setPublishTime(data.getDeployTime());
        forumPost.setDisplayTime(data.getDeployTime());
        forumPost.setDeliveryType(Byte.valueOf((byte)(!StringUtils.isBlank((CharSequence)data.getAreaCode()) ? 1 : 0)));
        forumPost.setStatus(Byte.valueOf((byte)(data.getUserType() == 4 || data.getUserType() == 5 ? 1 : 2)));
        if (!CollectionUtils.isEmpty((Collection)data.getComments())) {
            HashMap replyIdMap = new HashMap();
            forumPost.setReplyList(data.getComments().stream().map(comment -> this.convertReply((SpiderForumPostComment)comment, forumPost.getId(), replyIdMap)).collect(Collectors.toList()));
        }
        if (null != data.getTopicId()) {
            ForumPostTopic forumPostTopic = new ForumPostTopic();
            forumPostTopic.setId(this.nextSequence());
            forumPostTopic.setPostId(forumPost.getId());
            forumPostTopic.setTopicId(data.getTopicId());
            forumPost.setForumPostTopic(forumPostTopic);
        }
        return forumPost;
    }

    private String parseImageList(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            return "[]";
        }
        Document doc = Jsoup.parse((String)content);
        ArrayList postImg = Lists.newArrayList();
        Elements elements = doc.select("video");
        for (Element element : elements) {
            String videoUrl;
            Elements sources = element.select("source");
            if (null == sources || sources.size() != 1 || !StringUtils.isNotBlank((CharSequence)(videoUrl = ((Element)sources.get(0)).attr("src")))) continue;
            PostImg video = new PostImg();
            video.setVideoUrl(videoUrl);
            video.setType("VIDEO");
            postImg.add(video);
        }
        doc = Jsoup.parse((String)content);
        Elements ImgElements = doc.select("img");
        if (!CollectionUtils.isEmpty((Collection)ImgElements)) {
            for (Element element : ImgElements) {
                String imgUrl = element.attr("src");
                if (!StringUtils.isNotBlank((CharSequence)imgUrl)) continue;
                PostImg img = PostImg.buildImg((String)imgUrl);
                postImg.add(img);
            }
        }
        return JSONObject.toJSONString((Object)postImg);
    }

    private NewsReply convertReply(SpiderForumPostComment spiderForumPostComment, Long forumPostId, Map<Long, NewsReply> replyIdMap) {
        NewsReply newsReply = new NewsReply();
        newsReply.setId(this.nextSequence());
        newsReply.setUserId(spiderForumPostComment.getUserId());
        newsReply.setHeadImg(spiderForumPostComment.getHeadImg());
        newsReply.setUserNickname(spiderForumPostComment.getName());
        newsReply.setNewsId(forumPostId);
        newsReply.setAddTime(spiderForumPostComment.getDeployTime());
        if (spiderForumPostComment.getParentId() != null && replyIdMap.get(spiderForumPostComment.getParentId()) != null) {
            newsReply.setParentId(replyIdMap.get(spiderForumPostComment.getParentId()).getId());
            newsReply.setRootId(replyIdMap.get(spiderForumPostComment.getParentId()).getId());
            newsReply.setLevel(Byte.valueOf((byte)1));
            newsReply.setParentId(replyIdMap.get(spiderForumPostComment.getParentId()).getId());
            newsReply.setParentUserId(replyIdMap.get(spiderForumPostComment.getParentId()).getUserId());
            newsReply.setParentHeadImg(replyIdMap.get(spiderForumPostComment.getParentId()).getHeadImg());
            newsReply.setParentUserNickname(replyIdMap.get(spiderForumPostComment.getParentId()).getUserNickname());
        } else {
            newsReply.setParentId(Long.valueOf(0L));
            newsReply.setRootId(Long.valueOf(0L));
            newsReply.setLevel(Byte.valueOf((byte)0));
        }
        newsReply.setLikeCount(Integer.valueOf(0));
        newsReply.setReplyContent(spiderForumPostComment.getContent());
        newsReply.setType(Byte.valueOf((byte)3));
        newsReply.setStatus(Byte.valueOf((byte)1));
        newsReply.setInteractiveCount(Integer.valueOf(0));
        replyIdMap.put(spiderForumPostComment.getId(), newsReply);
        return newsReply;
    }

    private Long getPostId() {
        return this.redisStringAdapter.incrementWithDefault(RedisKey.SEQ_POST_ID, 4000000000000000L, 1);
    }
}

