/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.convert.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.convert.impl.AbstractConverter;
import com.bxm.localnews.sync.enums.LocalNewStatusEnum;
import com.bxm.localnews.sync.enums.LocalNewsTypeEnum;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsImg;
import com.bxm.localnews.sync.vo.spider.SpiderNews;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NewsConverter
extends AbstractConverter<SpiderNews, News> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public News convert(SpiderNews spiderNews) {
        News localNews = new News();
        localNews.setId(spiderNews.getId());
        ArrayList<NewsImg> newsVideoList = new ArrayList<NewsImg>();
        localNews.setContent(this.extractVideo(spiderNews.getContent(), newsVideoList));
        if (!CollectionUtils.isEmpty(newsVideoList)) {
            localNews.setVideoList(JSONObject.toJSONString(newsVideoList));
        }
        localNews.setTitle(spiderNews.getTitle());
        String[] imgArray = StringUtils.isEmpty((CharSequence)spiderNews.getImgUrl()) ? null : spiderNews.getImgUrl().split(";");
        localNews.setImgUrl(imgArray == null ? "" : this.toJsonString(imgArray));
        localNews.setAuthor(StringUtils.isEmpty((CharSequence)spiderNews.getSource()) ? "\u533f\u540d" : spiderNews.getSource());
        localNews.setAddress(spiderNews.getUrl());
        localNews.setAddTime(spiderNews.getCreateTime());
        localNews.setModifyTime(spiderNews.getCreateTime());
        localNews.setStatus(LocalNewStatusEnum.ENABLE.getCode());
        localNews.setType(LocalNewsTypeEnum.NEWS.getCode());
        localNews.setTop(Byte.valueOf((byte)1));
        localNews.setHot(Byte.valueOf((byte)1));
        localNews.setChannel(Byte.valueOf((byte)8));
        localNews.setKindId(this.getKindId(spiderNews.getChannel()));
        localNews.setKindName(spiderNews.getChannel());
        localNews.setKeywordList(spiderNews.getKeywordList());
        localNews.setSource(spiderNews.getSource());
        localNews.setReviewStatus(Byte.valueOf((byte)2));
        localNews.setKindTop(Byte.valueOf((byte)1));
        localNews.setEnablePlaceholder(Long.valueOf(0L));
        localNews.setCoverSelect(Byte.valueOf((byte)0));
        localNews.setDeliveryType(Integer.valueOf(0));
        this.generateNewsStatistic(localNews);
        if (StringUtil.isNotEmpty((String)spiderNews.getRegion())) {
            localNews.setAreaDetail(spiderNews.getRegion());
            localNews.setReviewStatus(Byte.valueOf((byte)0));
            localNews.setDeliveryType(Integer.valueOf(1));
            this.logger.debug("\uff08\u4fee\u6539\u548c\u65b0\u589e\u90fd\u4f1a\u8c03\u7528convert\u65b9\u6cd5\uff09\u672c\u5730\u65b0\u95fb\u4fdd\u5b58->{};{}", (Object)localNews.getTitle(), (Object)localNews.getDeliveryType());
        }
        if (!CollectionUtils.isEmpty((Collection)spiderNews.getCommentList())) {
            localNews.setNewsReplyList(this.convertNewsCommentToNewReply(spiderNews.getCommentList()));
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)spiderNews.getDeployTime())) {
                Date date = DateUtils.parseDateNonStrict((String)spiderNews.getDeployTime());
                Date maxDate = DateUtils.parseDate((String)"2038-01-01 00:00:00");
                Date minDate = DateUtils.parseDate((String)"1980-01-01 00:00:00");
                if (DateUtils.after((Date)date, (Date)maxDate) || DateUtils.after((Date)minDate, (Date)date)) {
                    localNews.setIssueTime(spiderNews.getCreateTime());
                } else {
                    localNews.setIssueTime(date);
                }
            } else {
                localNews.setIssueTime(spiderNews.getCreateTime());
            }
        }
        catch (Exception e) {
            this.logger.error("\u65f6\u95f4\u683c\u5f0f\u8f6c\u6362\u9519\u8bef:[{}]", (Object)JSONObject.toJSONString((Object)spiderNews));
            localNews.setIssueTime(spiderNews.getCreateTime());
        }
        finally {
            if (localNews.getIssueTime() == null) {
                this.logger.warn("\u65f6\u95f4\u4e3a\u7a7a\uff0c\u9700\u8981\u8865\u5145:[{}]", (Object)JSONObject.toJSONString((Object)spiderNews));
                localNews.setIssueTime(new Date());
            }
        }
        return localNews;
    }
}

