/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.convert.impl;

import com.bxm.localnews.service.VirtualUserService;
import com.bxm.localnews.sync.vo.business.VirtualUser;
import com.bxm.localnews.sync.vo.local.NewsReply;
import com.bxm.localnews.sync.vo.spider.NewsComment;
import com.bxm.newidea.component.tools.SpringContextHolder;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsReplyConverter {
    @Autowired
    private VirtualUserService virtualUserService;

    public List<NewsReply> judgeNewsReplyLevel(List<NewsReply> resultList, NewsComment newsComment) {
        if (Objects.isNull(newsComment)) {
            return resultList;
        }
        if (Objects.isNull(newsComment.getParentId())) {
            NewsReply newsReply = this.newsCommentToReply(newsComment);
            int praiseTimes = newsComment.getPraiseTimes() == null ? 0 : newsComment.getPraiseTimes();
            int commentTimes = newsComment.getCommentTimes() == null ? 0 : newsComment.getCommentTimes();
            newsReply.setInteractiveCount(Integer.valueOf(praiseTimes + commentTimes * 3));
            resultList.add(newsReply);
        }
        return resultList;
    }

    private NewsReply newsCommentToReply(NewsComment newsComment) {
        NewsReply reply = new NewsReply();
        reply.setInteractiveCount(Integer.valueOf(0));
        reply.setDeleteFlag((byte)0);
        reply.setType(newsComment.getType());
        List<VirtualUser> virtualUserList = ((VirtualUserService)SpringContextHolder.getBean(VirtualUserService.class)).list();
        VirtualUser virtualUser = virtualUserList.get((int)(Math.random() * (double)virtualUserList.size()));
        reply.setHeadImg(virtualUser.getHeadImg());
        reply.setUserId(virtualUser.getId());
        reply.setUserNickname(virtualUser.getNickname());
        reply.setNewsId(newsComment.getSourceId());
        reply.setAddTime(newsComment.getCreateTime());
        reply.setId(newsComment.getId());
        reply.setLikeCount(newsComment.getPraiseTimes());
        reply.setDeleteFlag((byte)0);
        reply.setStatus(Byte.valueOf((byte)1));
        reply.setRootId(Long.valueOf(0L));
        reply.setLevel(Byte.valueOf((byte)0));
        reply.setParentId(Long.valueOf(0L));
        if (StringUtils.isNotBlank((CharSequence)newsComment.getContent()) && newsComment.getContent().length() > 500) {
            reply.setReplyContent(newsComment.getContent().substring(0, 500));
        } else {
            reply.setReplyContent(newsComment.getContent());
        }
        return reply;
    }
}

