/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.convert.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.convert.impl.AbstractConverter;
import com.bxm.localnews.sync.enums.LocalNewStatusEnum;
import com.bxm.localnews.sync.enums.LocalNewsTypeEnum;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.local.NewsImg;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WechatNewsConverter
extends AbstractConverter<SpiderWechatNews, News> {
    @Override
    public News convert(SpiderWechatNews spiderWechatNews) {
        News localNews = new News();
        localNews.setId(spiderWechatNews.getId());
        localNews.setTitle(spiderWechatNews.getTitle());
        ArrayList<NewsImg> newsImgList = new ArrayList<NewsImg>();
        localNews.setContent(this.extractVideo(spiderWechatNews.getContent(), newsImgList));
        if (!CollectionUtils.isEmpty(newsImgList)) {
            localNews.setVideoList(JSONObject.toJSONString(newsImgList));
        }
        String[] imgArray = StringUtils.isEmpty((CharSequence)spiderWechatNews.getImgUrl()) ? null : spiderWechatNews.getImgUrl().split(";");
        localNews.setImgUrl(imgArray == null ? "" : this.toJsonString(imgArray));
        localNews.setAddress("");
        localNews.setAuthor(StringUtils.isEmpty((CharSequence)spiderWechatNews.getSource()) ? "\u533f\u540d" : spiderWechatNews.getSource());
        localNews.setAddTime(spiderWechatNews.getCreateTime());
        if (StringUtils.isNotEmpty((CharSequence)spiderWechatNews.getDeployTime())) {
            localNews.setIssueTime(DateUtils.parseDateNonStrict((String)spiderWechatNews.getDeployTime()));
        } else {
            localNews.setIssueTime(spiderWechatNews.getCreateTime());
        }
        localNews.setStatus(LocalNewStatusEnum.ENABLE.getCode());
        localNews.setType(LocalNewsTypeEnum.NEWS.getCode());
        localNews.setTop(Byte.valueOf((byte)1));
        localNews.setKindTop(Byte.valueOf((byte)1));
        localNews.setHot(Byte.valueOf((byte)1));
        localNews.setReviewStatus(Byte.valueOf((byte)2));
        localNews.setChannel(Byte.valueOf((byte)9));
        localNews.setSource(spiderWechatNews.getSource());
        localNews.setEnablePlaceholder(Long.valueOf(0L));
        localNews.setDeliveryType(Integer.valueOf(0));
        this.generateNewsStatistic(localNews);
        if (StringUtil.isNotEmpty((String)spiderWechatNews.getRegion())) {
            localNews.setAreaDetail(spiderWechatNews.getRegion());
            localNews.setReviewStatus(Byte.valueOf((byte)0));
            localNews.setDeliveryType(Integer.valueOf(1));
            this.logger.info("\u672c\u5730\u65b0\u95fb\u4fdd\u5b58-\u6765\u6e90\u5fae\u4fe1\u65b0\u95fb->{};{}", (Object)localNews.getTitle(), (Object)localNews.getDeliveryType());
        }
        localNews.setKindId(this.getKindId(spiderWechatNews.getChannel()));
        localNews.setKindName(spiderWechatNews.getChannel());
        return localNews;
    }
}

