/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.processer;

import com.bxm.localnews.channel.DataChannelProxy;
import com.bxm.localnews.constant.ProcesserOrder;
import com.bxm.localnews.processer.IProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.processer.impl.DefaultProcesser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProcesser
implements IProcesser {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected DataChannelProxy dataChannelProxy;
    private IProcesser nextProcesser;

    @Override
    public IProcesser next() {
        if (null == this.nextProcesser) {
            return new DefaultProcesser();
        }
        return this.nextProcesser;
    }

    @Override
    public void setNext(IProcesser processer) {
        this.nextProcesser = processer;
    }

    @Override
    public void process(ProcesserContext context) {
        if (this.match(context.getData())) {
            if (this.execute(context)) {
                this.next().process(context);
            }
        } else {
            this.next().process(context);
        }
    }

    protected abstract boolean execute(ProcesserContext var1);

    public int getOrder() {
        return ProcesserOrder.get(this.getClass());
    }
}

