/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.processer;

import com.bxm.localnews.processer.IProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class ProcesserChain
implements InitializingBean,
ApplicationContextAware {
    private IProcesser firstProcesser;
    private ApplicationContext applicationContext;

    public void process(ProcesserContext context) {
        this.firstProcesser.process(context);
    }

    public void afterPropertiesSet() {
        Map processerMap = this.applicationContext.getBeansOfType(IProcesser.class);
        Collection processers = processerMap.values();
        List result = processers.stream().sorted(Comparator.comparingInt(Ordered::getOrder)).collect(Collectors.toList());
        for (int i = 0; i < result.size() && i != result.size() - 1; ++i) {
            ((IProcesser)result.get(i)).setNext((IProcesser)result.get(i + 1));
        }
        this.firstProcesser = (IProcesser)result.get(0);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

