/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.processer.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.analysis.TFIDFAnalyzesService;
import com.bxm.localnews.config.SyncProperties;
import com.bxm.localnews.processer.AbstractProcesser;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.vo.Keyword;
import com.bxm.localnews.sync.vo.local.AdminNews;
import com.bxm.localnews.sync.vo.local.News;
import com.bxm.localnews.sync.vo.spider.SpiderNews;
import com.bxm.localnews.sync.vo.spider.SpiderWechatNews;
import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NewsKeywordProcesser
extends AbstractProcesser {
    private final TFIDFAnalyzesService tfidfAnalyzesService;
    private SyncProperties syncProperties;

    @Autowired
    public NewsKeywordProcesser(TFIDFAnalyzesService tfidfAnalyzesService, SyncProperties syncProperties) {
        this.tfidfAnalyzesService = tfidfAnalyzesService;
        this.syncProperties = syncProperties;
    }

    @Override
    protected boolean execute(ProcesserContext context) {
        Object data = context.getData();
        if (data instanceof SpiderNews) {
            SpiderNews news = (SpiderNews)data;
            List<Keyword> keywordList = null;
            if (StringUtils.isNotBlank((CharSequence)news.getKeyword())) {
                keywordList = this.convertKeywords(news.getKeyword());
            } else {
                if (StringUtils.isBlank((CharSequence)news.getTitle()) || StringUtils.isBlank((CharSequence)news.getContent())) {
                    this.logger.error("\u540c\u6b65\u51fa\u73b0\u6807\u9898\u548c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u5bfc\u81f4\u7a7a\u6307\u9488\u62a5\u9519:[{}]", JSONObject.toJSON((Object)news));
                    return false;
                }
                keywordList = this.tfidfAnalyzesService.analyze(news.getTitle(), news.getContent(), this.syncProperties.getTagPickCount());
            }
            news.setKeywordList(keywordList);
        } else if (data instanceof SpiderWechatNews) {
            SpiderWechatNews wechatNews = (SpiderWechatNews)data;
            List<Keyword> keywordList = this.tfidfAnalyzesService.analyze(wechatNews.getTitle(), wechatNews.getContent(), this.syncProperties.getTagPickCount());
            wechatNews.setKeywordList(keywordList);
        } else if (data instanceof News) {
            News localNews = (News)data;
            List<Keyword> keywordList = this.tfidfAnalyzesService.analyze(localNews.getTitle(), localNews.getContent(), this.syncProperties.getTagPickCount());
            localNews.setKeywordList(keywordList);
        } else if (data instanceof AdminNews) {
            AdminNews adminNews = (AdminNews)data;
            List<Keyword> keywordList = this.tfidfAnalyzesService.analyze(adminNews.getTitle(), adminNews.getContent(), this.syncProperties.getTagPickCount());
            adminNews.setKeywordList(keywordList);
        }
        return true;
    }

    private List<Keyword> convertKeywords(String keywords) {
        keywords = StringUtils.replaceAll((String)keywords, (String)"\uff0c", (String)",");
        keywords = StringUtils.replaceAll((String)keywords, (String)" ", (String)",");
        String[] keywordArray = StringUtils.split((String)keywords, (String)",");
        ArrayList keywordList = Lists.newArrayList();
        for (String keyword : keywordArray) {
            Keyword keywordObj = new Keyword();
            keywordObj.setName(keyword);
            keywordObj.setTfidfvalue(1.0);
            keywordList.add(keywordObj);
        }
        return keywordList;
    }

    @Override
    public boolean match(Object data) {
        return data instanceof SpiderNews || data instanceof SpiderWechatNews || data instanceof News || data instanceof AdminNews;
    }
}

