/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.bxm.localnews.config.SyncProperties;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.primary.dao.VideoFetchKeywordMapper;
import com.bxm.localnews.sync.vo.local.RepeatData;
import com.bxm.localnews.sync.vo.local.VideoFetchKeyword;
import com.bxm.localnews.sync.vo.spider.IDataVideo;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.DefaultKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@Deprecated
public class IDataVideoServie {
    private static final Logger logger = LoggerFactory.getLogger(IDataVideoServie.class);
    private final RedisStringAdapter redisStringAdapter;
    private VideoFetchKeywordMapper videoFetchKeywordMapper;
    private SyncProperties syncProperties;
    private ProcesserChain processerChain;
    private RedisSetAdapter redisSetAdapter;
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    public IDataVideoServie(RedisStringAdapter redisStringAdapter, RedisSetAdapter redisSetAdapter, RedisHashMapAdapter redisHashMapAdapter, VideoFetchKeywordMapper videoFetchKeywordMapper, SyncProperties syncProperties, ProcesserChain processerChain) {
        this.redisStringAdapter = redisStringAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.videoFetchKeywordMapper = videoFetchKeywordMapper;
        this.syncProperties = syncProperties;
        this.processerChain = processerChain;
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject postRequestFromUrl(String url, String body) throws IOException {
        URL realUrl = new URL(url);
        URLConnection conn = realUrl.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        PrintWriter out = new PrintWriter(conn.getOutputStream());
        out.print(body);
        out.flush();
        try (InputStream instream = conn.getInputStream();){
            JSONObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(instream, Charset.forName("UTF-8")));
            String jsonText = IDataVideoServie.readAll(rd);
            JSONObject jSONObject = json = JSON.parseObject((String)jsonText);
            return jSONObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject getRequestFromUrl(String url) throws IOException {
        URL realUrl = new URL(url);
        URLConnection conn = realUrl.openConnection();
        try (InputStream instream = conn.getInputStream();){
            JSONObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(instream, Charset.forName("UTF-8")));
            String jsonText = IDataVideoServie.readAll(rd);
            JSONObject jSONObject = json = JSON.parseObject((String)jsonText);
            return jSONObject;
        }
    }

    public void sync() {
        Date date = new Date();
        List list = this.videoFetchKeywordMapper.getAllList();
        ArrayList iDataVideoList = Lists.newArrayList();
        ArrayList meiPaiList = Lists.newArrayList();
        ArrayList miaopaiList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (VideoFetchKeyword v : list) {
                try {
                    meiPaiList.addAll(this.syncMeiPaiVideo(v));
                    Thread.sleep(1000L);
                    miaopaiList.addAll(this.syncMiaoPaiVideo(v));
                }
                catch (InterruptedException e) {
                    logger.error("\u5f53\u524d\u7ebf\u7a0b[{}]\u540c\u6b65\u89c6\u9891\u5f02\u5e38", (Object)e.getMessage());
                }
            }
        }
        String key = DateUtils.formatAtWill((Date)date, (String)"yyyyMMddHH");
        iDataVideoList.addAll(this.repeatIDataVideo(meiPaiList, 2, key));
        iDataVideoList.addAll(this.repeatIDataVideo(miaopaiList, 3, key));
        logger.info("\u5f53\u524d\u9700\u8981\u540c\u6b65\u7684\u89c6\u9891\u957f\u5ea6\u4e3a\uff1a[{}]", (Object)iDataVideoList.size());
        this.excute(iDataVideoList);
    }

    private List<IDataVideo> syncDouyinVideo(VideoFetchKeyword v) {
        HashMap map = Maps.newHashMap();
        map.put("apikey", this.syncProperties.getVideoApiKey());
        map.put("kw", v.getName());
        String apiUrl = this.syncProperties.getDouyinApi();
        List<IDataVideo> list = this.getVideo(apiUrl, map, v, "\u6296\u97f3");
        this.addValueToVideoList(list);
        return list;
    }

    private List<IDataVideo> syncMeiPaiVideo(VideoFetchKeyword v) {
        HashMap map = Maps.newHashMap();
        map.put("apikey", this.syncProperties.getVideoApiKey());
        map.put("kw", v.getName());
        String apiUrl = this.syncProperties.getMeipaiApi();
        List<IDataVideo> list = this.getVideo(apiUrl, map, v, "\u7f8e\u62cd");
        this.addValueToVideoList(list);
        return list;
    }

    private List<IDataVideo> syncMiaoPaiVideo(VideoFetchKeyword v) {
        HashMap map = Maps.newHashMap();
        map.put("apikey", this.syncProperties.getVideoApiKey());
        map.put("kw", v.getName());
        String apiUrl = this.syncProperties.getMiaopaiApi();
        List<IDataVideo> list = this.getVideo(apiUrl, map, v, "\u79d2\u62cd");
        this.addValueToVideoList(list);
        return list;
    }

    private void addValueToVideoList(List<IDataVideo> list) {
        list.forEach(dataVideo -> {
            String videoId = dataVideo.getId();
            dataVideo.setVideoId(videoId);
            dataVideo.setId(this.getVideoId().toString());
            dataVideo.setStatus(Byte.valueOf((byte)1));
        });
    }

    private void excute(List<IDataVideo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (IDataVideo dataVideo : list) {
            ProcesserContext<IDataVideo> context = new ProcesserContext<IDataVideo>();
            context.setData(dataVideo);
            this.processerChain.process(context);
        }
    }

    private List<IDataVideo> repeatIDataVideo(List<IDataVideo> list, int videoType, String key) {
        ArrayList dataVideoList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return dataVideoList;
        }
        ArrayList repeatDatas = Lists.newArrayList();
        switch (videoType) {
            case 1: {
                Set stringSet = this.redisSetAdapter.getAllMembers(this.getDouYinVideoListKey(), String.class);
                list.forEach(iDataVideo -> {
                    if (!stringSet.contains(iDataVideo.getVideoId())) {
                        dataVideoList.add(iDataVideo);
                        stringSet.add(iDataVideo.getVideoId());
                    } else {
                        logger.info("\u722c\u53d6\u7684\u6296\u97f3\u89c6\u9891id\u4e3a[{}]----\u672c\u5730\u5b58\u5165\u7684\u89c6\u9891title\u4e3a[{}]\u548cdescription\u4e3a[{}]\u91cd\u590d", new Object[]{iDataVideo.getVideoId(), iDataVideo.getTitle(), iDataVideo.getDescription()});
                        repeatDatas.add(iDataVideo.getVideoId());
                    }
                });
                Object[] array = (String[])stringSet.stream().toArray(String[]::new);
                this.redisSetAdapter.add(this.getDouYinVideoListKey(), array);
                Date date = new Date();
                RepeatData repeatData = new RepeatData(date, Long.valueOf(list.size()), Long.valueOf(repeatDatas.size()), Long.valueOf(stringSet.size()));
                this.redisHashMapAdapter.put(this.getRepeatKey(videoType), key, (Object)repeatData);
                break;
            }
            case 2: {
                Set stringSet = this.redisSetAdapter.getAllMembers(this.getMeipaiVideoListKey(), String.class);
                list.forEach(iDataVideo -> {
                    if (!stringSet.contains(iDataVideo.getVideoId())) {
                        dataVideoList.add(iDataVideo);
                        stringSet.add(iDataVideo.getVideoId());
                    } else {
                        logger.info("\u722c\u53d6\u7684\u7f8e\u62cd\u89c6\u9891id\u4e3a[{}]----\u672c\u5730\u5b58\u5165\u7684\u89c6\u9891title\u4e3a[{}]\u548cdescription\u4e3a[{}]\u91cd\u590d", new Object[]{iDataVideo.getVideoId(), iDataVideo.getTitle(), iDataVideo.getDescription()});
                        repeatDatas.add(iDataVideo.getVideoId());
                    }
                });
                Object[] array = (String[])stringSet.stream().toArray(String[]::new);
                this.redisSetAdapter.add(this.getMeipaiVideoListKey(), array);
                Date date = new Date();
                RepeatData repeatData = new RepeatData(date, Long.valueOf(list.size()), Long.valueOf(repeatDatas.size()), Long.valueOf(stringSet.size()));
                this.redisHashMapAdapter.put(this.getRepeatKey(videoType), key, (Object)repeatData);
                break;
            }
            case 3: {
                Set stringSet = this.redisSetAdapter.getAllMembers(this.getMiaoPaiVideoListKey(), String.class);
                list.forEach(iDataVideo -> {
                    if (!stringSet.contains(iDataVideo.getVideoId())) {
                        dataVideoList.add(iDataVideo);
                        stringSet.add(iDataVideo.getVideoId());
                    } else {
                        logger.info("\u722c\u53d6\u7684\u79d2\u62cd\u89c6\u9891id\u4e3a[{}]----\u672c\u5730\u5b58\u5165\u7684\u89c6\u9891title\u4e3a[{}]\u548cdescription\u4e3a[{}]\u91cd\u590d", new Object[]{iDataVideo.getVideoId(), iDataVideo.getTitle(), iDataVideo.getDescription()});
                        repeatDatas.add(iDataVideo.getVideoId());
                    }
                });
                Object[] array = (String[])stringSet.stream().toArray(String[]::new);
                this.redisSetAdapter.add(this.getMiaoPaiVideoListKey(), array);
                Date date = new Date();
                RepeatData repeatData = new RepeatData(date, Long.valueOf(list.size()), Long.valueOf(repeatDatas.size()), Long.valueOf(stringSet.size()));
                this.redisHashMapAdapter.put(this.getRepeatKey(videoType), key, (Object)repeatData);
                break;
            }
        }
        return dataVideoList;
    }

    private List<IDataVideo> getVideo(String apiUrl, HashMap<String, String> map, VideoFetchKeyword v, String videoType) {
        ArrayList list;
        block10: {
            list = Lists.newArrayList();
            TypeReference<List<IDataVideo>> typeReference = new TypeReference<List<IDataVideo>>(){};
            String url = this.generateUrl(apiUrl, map);
            try {
                JSONObject json = IDataVideoServie.getRequestFromUrl(url);
                if (StringUtils.isEmpty((Object)json)) {
                    return list;
                }
                if (!this.isRequestSuccess(json)) break block10;
                try {
                    JSONArray jsonArray = json.getJSONArray("data");
                    List jsonList = (List)JSONObject.parseObject((String)jsonArray.toJSONString(), (TypeReference)typeReference, (Feature[])new Feature[0]);
                    list.addAll(jsonList);
                    String pageToken = json.getString("pageToken");
                    if (StringUtils.isEmpty((Object)pageToken)) break block10;
                    map.put("pageToken", json.getString("pageToken"));
                    url = this.generateUrl(apiUrl, map);
                    try {
                        Thread.sleep(1000L);
                        json = IDataVideoServie.getRequestFromUrl(url);
                        if (this.isRequestSuccess(json)) {
                            try {
                                jsonArray = json.getJSONArray("data");
                                jsonList = (List)JSONObject.parseObject((String)jsonArray.toJSONString(), (TypeReference)typeReference, (Feature[])new Feature[0]);
                                list.addAll(jsonList);
                            }
                            catch (Exception e) {
                                logger.error("\u7b2c\u4e8c\u6b21\u540c\u6b65[{}]\u89c6\u9891--\u5173\u952e\u5b57id\u4e3a[{}], \u540d\u79f0\u4e3a[{}]\u83b7\u53d6\u7684json\u6570\u636e\u89e3\u6790\u5f02\u5e38", new Object[]{videoType, v.getId(), v.getName()});
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u83b7\u53d6\u4e0b\u4e00\u9875\u540c\u6b65\u89c6\u9891[{}]\u5bf9\u5e94\u5173\u952e\u5b57\u7684id\u4e3a[{}], \u540d\u79f0\u4e3a[{}]\u53d1\u751f\u9519\u8bef", new Object[]{videoType, v.getId(), v.getName()});
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                catch (Exception e) {
                    logger.error("[{}]\u89c6\u9891--\u5173\u952e\u5b57id\u4e3a[{}], \u540d\u79f0\u4e3a[{}]\u83b7\u53d6\u7684json\u6570\u636e\u89e3\u6790\u5f02\u5e38", new Object[]{videoType, v.getId(), v.getName()});
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u89c6\u9891[{}]\u5bf9\u5e94\u5173\u952e\u5b57\u7684id\u4e3a[{}], \u540d\u79f0\u4e3a[{}]\u53d1\u751f\u9519\u8bef", new Object[]{videoType, v.getId(), v.getName()});
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    private boolean isRequestSuccess(JSONObject jsonObject) {
        String retCode = jsonObject.getString("retcode");
        return retCode.equals("000000") || retCode.equals("0");
    }

    private String generateUrl(String url, HashMap<String, String> map) {
        String params = Joiner.on((String)"&").withKeyValueSeparator("=").join(map);
        logger.info("\u5f53\u524d\u540c\u6b65\u7684api\u5730\u5740\u4e3a\uff1a[{}]", (Object)(url + "?" + params));
        return url + "?" + params;
    }

    private Long getVideoId() {
        if (!this.redisStringAdapter.hasKey(this.getMaxVideoIdKey()).booleanValue()) {
            this.redisStringAdapter.set(this.getMaxVideoIdKey(), 5000000000L);
            return 5000000000L;
        }
        return this.redisStringAdapter.increment(this.getMaxVideoIdKey());
    }

    private KeyGenerator getMaxVideoIdKey() {
        return DefaultKeyGenerator.build((String)"sync", (String)"video").copy().appendKey((Object)"max_id");
    }

    private KeyGenerator getDouYinVideoListKey() {
        return DefaultKeyGenerator.build((String)"sync", (String)"video").copy().appendKey((Object)"douyin_list");
    }

    private KeyGenerator getMiaoPaiVideoListKey() {
        return DefaultKeyGenerator.build((String)"sync", (String)"video").copy().appendKey((Object)"miaopai_list");
    }

    private KeyGenerator getMeipaiVideoListKey() {
        return DefaultKeyGenerator.build((String)"sync", (String)"video").copy().appendKey((Object)"meipai_list");
    }

    private KeyGenerator getRepeatKey(int videoType) {
        return DefaultKeyGenerator.build((String)"sync", (String)"video").copy().appendKey((Object)videoType);
    }
}

