/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsAgingTagMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.LocalnewsPersistentTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsAgingTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsKindMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentRecommendedMapper;
import com.bxm.localnews.sync.primary.dao.NewsPersistentTagMapper;
import com.bxm.localnews.sync.primary.dao.NewsReplyMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.third.dao.AreaDivisionMapper;
import com.bxm.localnews.sync.vo.local.AreaDivision;
import com.bxm.localnews.sync.vo.local.LocalnewsAging;
import com.bxm.localnews.sync.vo.local.NewsKind;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsTag;
import com.bxm.newidea.component.service.BaseService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class NewsCleanService
extends BaseService {
    private static final String primarySessionTemplate = "primarySessionTemplate";
    private final LocalnewsAgingMapper localnewsAgingMapper;
    private final LocalnewsPersistentMapper localnewsPersistentMapper;
    private final NewsPersistentMapper newsPersistentMapper;
    private final NewsAgingMapper newsAgingMapper;
    private final AreaDivisionMapper areaDivisionMapper;
    private final NewsKindMapper newsKindMapper;
    private final NewsReplyMapper newsReplyMapper;

    @Autowired
    public NewsCleanService(LocalnewsAgingMapper localnewsAgingMapper, LocalnewsPersistentMapper localnewsPersistentMapper, NewsPersistentMapper newsPersistentMapper, NewsAgingMapper newsAgingMapper, AreaDivisionMapper areaDivisionMapper, NewsKindMapper newsKindMapper, NewsReplyMapper newsReplyMapper) {
        this.localnewsAgingMapper = localnewsAgingMapper;
        this.localnewsPersistentMapper = localnewsPersistentMapper;
        this.newsPersistentMapper = newsPersistentMapper;
        this.newsAgingMapper = newsAgingMapper;
        this.areaDivisionMapper = areaDivisionMapper;
        this.newsKindMapper = newsKindMapper;
        this.newsReplyMapper = newsReplyMapper;
    }

    @Transactional(rollbackFor={Exception.class})
    public void clean() {
        Date today = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.add(10, -240);
        Date agingTime = calendar.getTime();
        calendar.setTime(today);
        calendar.add(10, -2160);
        Date persistenceTime = calendar.getTime();
        this.cleanLocationNews(agingTime, persistenceTime);
        this.cleanInvalidNews();
        this.cleanNationalNews(agingTime, persistenceTime);
    }

    private void cleanInvalidNews() {
        List newsReplyList = this.newsReplyMapper.selectWithoutPostId();
        MybatisBatchBuilder.create(NewsReplyMapper.class, (Collection)newsReplyList).sessionTemplateName(primarySessionTemplate).run((mapper, newsReply) -> mapper.deleteNewsReplyByNewsIdAndType(newsReply.getNewsId(), Integer.valueOf(newsReply.getType().byteValue())));
        MybatisBatchBuilder.create(UserReplyMapper.class, (Collection)newsReplyList).sessionTemplateName(primarySessionTemplate).run((mapper, newsReply) -> mapper.deleteUserReplyByNewsIdAndType(newsReply.getNewsId(), Integer.valueOf(newsReply.getType().byteValue()), newsReply.getUserId()));
    }

    private void cleanLocationNews(Date agingTime, Date persistenceTime) {
        AreaDivision areaDivision = new AreaDivision();
        areaDivision.setLevel(Byte.valueOf((byte)1));
        List areaDivisionList = this.areaDivisionMapper.selectByModel(areaDivision);
        for (AreaDivision a : areaDivisionList) {
            String province = a.getCode();
            List localnewsAgingIds = this.localnewsAgingMapper.selectByLimitTime(Long.valueOf(province), agingTime);
            ArrayList<LocalnewsAging> localNewsAgingList = new ArrayList<LocalnewsAging>();
            ArrayList<NewsRecommended> newsRecommendedAgingList = new ArrayList<NewsRecommended>();
            ArrayList<NewsTag> newsTagAgingList = new ArrayList<NewsTag>();
            this.fillTheObject(localnewsAgingIds, Long.valueOf(province), localNewsAgingList, newsRecommendedAgingList, newsTagAgingList);
            MybatisBatchBuilder.create(LocalnewsAgingMapper.class, localNewsAgingList).sessionTemplateName(primarySessionTemplate).run(LocalnewsAgingMapper::deleteByModel);
            MybatisBatchBuilder.create(LocalnewsAgingRecommendedMapper.class, newsRecommendedAgingList).sessionTemplateName(primarySessionTemplate).run(LocalnewsAgingRecommendedMapper::deleteByModel);
            MybatisBatchBuilder.create(LocalnewsAgingTagMapper.class, newsTagAgingList).sessionTemplateName(primarySessionTemplate).run(LocalnewsAgingTagMapper::deleteByModel);
            List localnewsIds = this.localnewsPersistentMapper.selectByLimitTime(Long.valueOf(province), persistenceTime);
            ArrayList<LocalnewsAging> localNewsPerList = new ArrayList<LocalnewsAging>();
            ArrayList<NewsRecommended> newsRecommendedperList = new ArrayList<NewsRecommended>();
            ArrayList<NewsTag> newsTagPerList = new ArrayList<NewsTag>();
            this.fillTheObject(localnewsIds, Long.valueOf(province), localNewsPerList, newsRecommendedperList, newsTagPerList);
            MybatisBatchBuilder.create(LocalnewsPersistentMapper.class, localNewsPerList).sessionTemplateName(primarySessionTemplate).run(LocalnewsPersistentMapper::deleteByModel);
            MybatisBatchBuilder.create(LocalnewsPersistentRecommendedMapper.class, newsRecommendedperList).sessionTemplateName(primarySessionTemplate).run(LocalnewsPersistentRecommendedMapper::deleteByModel);
            MybatisBatchBuilder.create(LocalnewsPersistentTagMapper.class, newsTagPerList).sessionTemplateName(primarySessionTemplate).run(LocalnewsPersistentTagMapper::deleteByModel);
        }
    }

    private void cleanNationalNews(Date agingTime, Date persistenceTime) {
        List kindIdList = this.newsKindMapper.selectAllKinds();
        for (NewsKind newsKind : kindIdList) {
            List newsAgingIdList = this.newsAgingMapper.selectByKindId(newsKind.getId(), Integer.valueOf(5000));
            MybatisBatchBuilder.create(NewsAgingMapper.class, (Collection)newsAgingIdList).sessionTemplateName(primarySessionTemplate).run(NewsAgingMapper::deleteById);
            MybatisBatchBuilder.create(NewsAgingRecommendedMapper.class, (Collection)newsAgingIdList).sessionTemplateName(primarySessionTemplate).run(NewsAgingRecommendedMapper::deleteByNewsId);
            MybatisBatchBuilder.create(NewsAgingTagMapper.class, (Collection)newsAgingIdList).sessionTemplateName(primarySessionTemplate).run(NewsAgingTagMapper::deleteByNewsId);
        }
        List newsPerIdList = this.newsPersistentMapper.selectByLimitTime(persistenceTime);
        MybatisBatchBuilder.create(NewsPersistentMapper.class, (Collection)newsPerIdList).sessionTemplateName(primarySessionTemplate).run(NewsPersistentMapper::deleteById);
        MybatisBatchBuilder.create(NewsPersistentRecommendedMapper.class, (Collection)newsPerIdList).sessionTemplateName(primarySessionTemplate).run(NewsPersistentRecommendedMapper::deleteByNewsId);
        MybatisBatchBuilder.create(NewsPersistentTagMapper.class, (Collection)newsPerIdList).sessionTemplateName(primarySessionTemplate).run(NewsPersistentTagMapper::deleteByNewsId);
    }

    private void fillTheObject(List<Long> ids, Long province, List<LocalnewsAging> localnewsAgingList, List<NewsRecommended> newsRecommendedList, List<NewsTag> newsTagList) {
        ids.forEach(id -> {
            LocalnewsAging localnewsAging = new LocalnewsAging();
            localnewsAging.setProvince(province);
            localnewsAging.setId(id);
            localnewsAgingList.add(localnewsAging);
            NewsRecommended newsRecommended = new NewsRecommended();
            newsRecommended.setProvince(province);
            newsRecommended.setNewsId(id);
            newsRecommendedList.add(newsRecommended);
            NewsTag newsTag = new NewsTag();
            newsTag.setProvince(province);
            newsTag.setNewsId(id);
            newsTagList.add(newsTag);
        });
    }
}

