/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.primary.dao.NewsKindMapper;
import com.bxm.localnews.sync.primary.dao.NewsPoolMapper;
import com.bxm.localnews.sync.vo.local.NewsKind;
import com.bxm.localnews.sync.vo.local.NewsPool;
import com.bxm.localnews.thread.NewsPoolSyncThread;
import com.bxm.newidea.component.service.BaseService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Resource;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class NewsPoolSyncService
extends BaseService {
    private static CountDownLatch countDownLatch = null;
    @Resource
    private NewsPoolMapper newsPoolMapper;
    @Resource
    private ProcesserChain processerChain;
    @Resource
    private AsyncTaskExecutor taskExecutor;
    @Resource
    private NewsKindMapper newsKindMapper;

    public void sync(Integer offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(6, -7);
        Date lastModifyTime = calendar.getTime();
        this.execute(offset, lastModifyTime);
    }

    private void execute(Integer offset, Date limitDate) {
        List list = this.newsPoolMapper.listNewsPool(Long.valueOf(offset.intValue()), limitDate);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.logger.info("\u7f13\u51b2\u6c60\u6570\u636e\u586b\u5145\u5f00\u59cb\uff0c\u9891\u9053\uff1a{},\u6570\u91cf\uff1a{}", (Object)offset, (Object)list.size());
        for (NewsPool news : list) {
            ProcesserContext<NewsPool> context = new ProcesserContext<NewsPool>();
            news.setStatus(Byte.valueOf((byte)1));
            context.setData(news);
            this.processerChain.process(context);
        }
        this.logger.info("\u7f13\u51b2\u6c60\u6570\u636e\u586b\u5145\u5b8c\u6bd5\uff0c\u9891\u9053\uff1a{},\u6570\u91cf\uff1a{}", (Object)offset, (Object)list.size());
    }

    @Async
    public void syncNewsPool() {
        if (countDownLatch == null || countDownLatch.getCount() == 0L) {
            List kindList = this.newsKindMapper.selectAllKinds();
            countDownLatch = new CountDownLatch(kindList.size());
            for (NewsKind newsKind : kindList) {
                this.newsPoolMapper.deleteTotal(Long.valueOf(newsKind.getId().intValue()));
                this.taskExecutor.execute((Runnable)new NewsPoolSyncThread().build(newsKind.getId(), countDownLatch));
            }
        }
    }
}

