/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.vo.local.NewsRecommended;
import com.bxm.localnews.sync.vo.local.NewsStatistics;
import com.bxm.newidea.component.service.BaseService;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NewsStatisticService
extends BaseService {
    private static SoftReference<ConcurrentMap<String, NewsStatistics>> cache;
    @Autowired
    private ProcesserChain processerChain;

    @Async
    public void updateStatistic(List<NewsStatistics> newsStatisticsList) {
        for (NewsStatistics newsStatistics : newsStatisticsList) {
            String newsId;
            ConcurrentMap<String, NewsStatistics> dataMap;
            if (cache == null) {
                ConcurrentMap<String, NewsStatistics> concurrentMap = this.getCache();
            }
            if ((dataMap = cache.get()) == null) {
                dataMap = this.getCache();
            }
            if (dataMap.containsKey(newsId = String.valueOf(newsStatistics.getNewsId()))) {
                NewsStatistics statistics = (NewsStatistics)dataMap.get(newsId);
                dataMap.put(newsId, this.plus(newsStatistics, statistics));
                continue;
            }
            dataMap.put(newsId, newsStatistics);
        }
    }

    private NewsStatistics plus(NewsStatistics n1, NewsStatistics n2) {
        n1.setRecommends(Integer.valueOf((n1.getRecommends() == null ? 0 : n1.getRecommends()) + (n2.getRecommends() == null ? 0 : n2.getRecommends())));
        n1.setComments(Integer.valueOf((n1.getComments() == null ? 0 : n1.getComments()) + (n2.getComments() == null ? 0 : n2.getComments())));
        n1.setActiveViews(Integer.valueOf((n1.getActiveViews() == null ? 0 : n1.getActiveViews()) + (n2.getActiveViews() == null ? 0 : n2.getActiveViews())));
        n1.setClicks(Integer.valueOf((n1.getClicks() == null ? 0 : n1.getClicks()) + (n2.getClicks() == null ? 0 : n2.getClicks())));
        n1.setCollects(Integer.valueOf((n1.getCollects() == null ? 0 : n1.getCollects()) + (n2.getCollects() == null ? 0 : n2.getCollects())));
        n1.setNewClicks(Integer.valueOf((n1.getNewClicks() == null ? 0 : n1.getNewClicks()) + (n2.getNewClicks() == null ? 0 : n2.getNewClicks())));
        n1.setShares(Integer.valueOf((n1.getShares() == null ? 0 : n1.getShares()) + (n2.getShares() == null ? 0 : n2.getShares())));
        n1.setViews(Integer.valueOf((n1.getViews() == null ? 0 : n1.getViews()) + (n2.getViews() == null ? 0 : n2.getViews())));
        return n1;
    }

    private ConcurrentMap<String, NewsStatistics> getCache() {
        ConcurrentHashMap<String, NewsStatistics> dataMap = new ConcurrentHashMap<String, NewsStatistics>();
        cache = new SoftReference(dataMap);
        return dataMap;
    }

    public void sync() {
        if (cache == null) {
            return;
        }
        ConcurrentMap<String, NewsStatistics> dataMap = cache.get();
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        ConcurrentHashMap<String, NewsStatistics> statisticMap = new ConcurrentHashMap<String, NewsStatistics>(dataMap);
        dataMap.clear();
        this.logger.info("\u83b7\u53d6\u7f13\u51b2\u9759\u6001\u6570\u636e\uff1a{}", (Object)JSON.toJSONString(statisticMap));
        statisticMap.forEach((k, v) -> {
            ProcesserContext<NewsStatistics> context = new ProcesserContext<NewsStatistics>();
            context.setData((NewsStatistics)v);
            this.processerChain.process(context);
        });
    }

    @Async
    public void saveRecommended(List<NewsRecommended> newsRecommendedList) {
        for (NewsRecommended newsRecommended : newsRecommendedList) {
            ProcesserContext<NewsRecommended> context = new ProcesserContext<NewsRecommended>();
            context.setData(newsRecommended);
            this.processerChain.process(context);
        }
    }
}

