/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.sync.primary.dao.ForumPostMapper;
import com.bxm.localnews.sync.primary.dao.UserReplyMapper;
import com.bxm.localnews.sync.third.dao.UserMapper;
import com.bxm.localnews.sync.vo.business.User;
import com.bxm.localnews.sync.vo.business.UserStatistic;
import com.bxm.newidea.component.service.BaseService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class UserStatisticService
extends BaseService {
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private UserReplyMapper userReplyMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    @Qualifier(value="thirdSessionTemplate")
    private SqlSessionTemplate thirdSessionTemplate;

    public void sync(List<Long> idList, Integer offset) {
        String tableName = "a_user_reply_" + offset;
        ArrayList<UserStatistic> userStatisticList = new ArrayList<UserStatistic>();
        for (Long id : idList) {
            int userReplyCount = this.userReplyMapper.calculateReplyNumByUser(tableName, id);
            int userPostCount = this.forumPostMapper.calculatePostNumByUser(id);
            UserStatistic userStatistic = new UserStatistic(id, userPostCount, userReplyCount);
            userStatisticList.add(userStatistic);
        }
        MybatisBatchBuilder.create(UserMapper.class, userStatisticList).sessionTemplate(this.thirdSessionTemplate).run(UserMapper::updateUserStatistic);
    }

    public User getUserInfo(Map<Long, User> userMap, Long userId) {
        User user;
        if (userMap.get(userId) != null) {
            user = userMap.get(userId);
        } else {
            user = this.userMapper.selectUserById(userId);
            userMap.put(userId, user);
        }
        return user;
    }
}

