/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.service;

import com.bxm.localnews.constant.RedisKey;
import com.bxm.localnews.processer.ProcesserChain;
import com.bxm.localnews.processer.ProcesserContext;
import com.bxm.localnews.sync.second.dao.SpiderVideoMapper;
import com.bxm.localnews.sync.second.dao.VideoCommentMapper;
import com.bxm.localnews.sync.vo.spider.SpiderVideo;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VideoSyncService
extends BaseService {
    private final RedisStringAdapter redisStringAdapter;
    private final SpiderVideoMapper spiderVideoMapper;
    private final ProcesserChain processerChain;
    private final VideoCommentMapper videoCommentMapper;

    @Autowired
    public VideoSyncService(RedisStringAdapter redisStringAdapter, SpiderVideoMapper spiderVideoMapper, ProcesserChain processerChain, VideoCommentMapper videoCommentMapper) {
        this.redisStringAdapter = redisStringAdapter;
        this.spiderVideoMapper = spiderVideoMapper;
        this.processerChain = processerChain;
        this.videoCommentMapper = videoCommentMapper;
    }

    public void sync() {
        Date lastSyncTime = (Date)this.redisStringAdapter.get(RedisKey.SPIDER_VIDEO_SYNC, Date.class);
        if (null == lastSyncTime) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(6, -14);
            lastSyncTime = calendar.getTime();
        }
        this.execute(lastSyncTime);
    }

    private void execute(Date limitDate) {
        List list = this.spiderVideoMapper.listForSync(limitDate, Integer.valueOf(1));
        if (list == null || list.isEmpty()) {
            return;
        }
        for (SpiderVideo video : list) {
            ProcesserContext<SpiderVideo> context = new ProcesserContext<SpiderVideo>();
            context.setData(video);
            List videoComments = this.videoCommentMapper.selectVideoCommentsBySourceId(video.getId());
            video.setVideoComments(videoComments);
            this.processerChain.process(context);
        }
        SpiderVideo spiderVideo = (SpiderVideo)list.get(list.size() - 1);
        this.redisStringAdapter.set(RedisKey.SPIDER_VIDEO_SYNC, (Object)spiderVideo.getModifyTime());
        this.execute(spiderVideo.getModifyTime());
    }
}

